/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.objects.Branch;
import org.eclipse.orion.server.git.objects.Log;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;

public class ListBranchesJob
extends GitJob {
    private IPath path;
    private URI cloneLocation;
    private int commitsSize;
    private int pageNo;
    private int pageSize;
    private String baseLocation;
    private String nameFilter;

    public ListBranchesJob(String userRunningTask, IPath repositoryPath, URI cloneLocation, int commitsSize, int pageNo, int pageSize, String baseLocation, String nameFilter) {
        super(userRunningTask, false);
        this.path = repositoryPath;
        this.cloneLocation = cloneLocation;
        this.commitsSize = commitsSize;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.baseLocation = baseLocation;
        this.nameFilter = nameFilter;
        this.setFinalMessage("Branches list generated");
    }

    public ListBranchesJob(String userRunningTask, IPath repositoryPath, URI cloneLocation) {
        this(userRunningTask, repositoryPath, cloneLocation, 0, 0, -1, null, null);
    }

    public ListBranchesJob(String userRunningTask, IPath repositoryPath, URI cloneLocation, int commitsSize) {
        this(userRunningTask, repositoryPath, cloneLocation, commitsSize, 0, -1, null, null);
    }

    private ObjectId getCommitObjectId(Repository db, ObjectId oid) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevWalk walk = new RevWalk(db);
        try {
            RevCommit revCommit = walk.parseCommit((AnyObjectId)oid);
            return revCommit;
        }
        finally {
            walk.release();
        }
    }

    protected IStatus performJob() {
        Repository db = null;
        try {
            File gitDir = GitUtils.getGitDir(this.path);
            db = FileRepositoryBuilder.create((File)gitDir);
            Git git = new Git(db);
            List branchRefs = git.branchList().call();
            ArrayList<Branch> branches = new ArrayList<Branch>(branchRefs.size());
            for (Ref ref : branchRefs) {
                if (this.nameFilter != null && !this.nameFilter.equals("")) {
                    String shortName = Repository.shortenRefName((String)ref.getName());
                    if (!shortName.toLowerCase().contains(this.nameFilter.toLowerCase())) continue;
                    branches.add(new Branch(this.cloneLocation, db, ref));
                    continue;
                }
                branches.add(new Branch(this.cloneLocation, db, ref));
            }
            Collections.sort(branches, Branch.COMPARATOR);
            JSONObject result = new JSONObject();
            JSONArray children = new JSONArray();
            int firstBranch = this.pageSize > 0 ? this.pageSize * (this.pageNo - 1) : 0;
            int lastBranch = this.pageSize > 0 ? firstBranch + this.pageSize - 1 : branches.size() - 1;
            int n = lastBranch = lastBranch > branches.size() - 1 ? branches.size() - 1 : lastBranch;
            if (this.pageNo > 1 && this.baseLocation != null) {
                String prev = String.valueOf(this.baseLocation) + "?page=" + (this.pageNo - 1) + "&pageSize=" + this.pageSize;
                if (this.nameFilter != null && !this.nameFilter.equals("")) {
                    prev = String.valueOf(prev) + "&filter=" + GitUtils.encode(this.nameFilter);
                }
                if (this.commitsSize > 0) {
                    prev = String.valueOf(prev) + "&commits=" + this.commitsSize;
                }
                result.put("PreviousLocation", (Object)prev);
            }
            if (lastBranch < branches.size() - 1) {
                String next = String.valueOf(this.baseLocation) + "?page=" + (this.pageNo + 1) + "&pageSize=" + this.pageSize;
                if (this.nameFilter != null && !this.nameFilter.equals("")) {
                    next = String.valueOf(next) + "&filter=" + GitUtils.encode(this.nameFilter);
                }
                if (this.commitsSize > 0) {
                    next = String.valueOf(next) + "&commits=" + this.commitsSize;
                }
                result.put("NextLocation", (Object)next);
            }
            int i = firstBranch;
            while (i <= lastBranch) {
                Branch branch = (Branch)branches.get(i);
                if (this.commitsSize == 0) {
                    children.put((Object)branch.toJSON());
                } else {
                    String branchName = branch.getName(true, false);
                    ObjectId toObjectId = db.resolve(branchName);
                    Ref toRefId = db.getRef(branchName);
                    if (toObjectId == null) {
                        String msg = NLS.bind((String)"No ref or commit found: {0}", (Object)branchName);
                        ServerStatus serverStatus = new ServerStatus(4, 404, msg, null);
                        return serverStatus;
                    }
                    toObjectId = this.getCommitObjectId(db, toObjectId);
                    Log log = null;
                    if (this.commitsSize == 1 && toObjectId instanceof RevCommit) {
                        log = new Log(this.cloneLocation, db, Collections.singleton((RevCommit)toObjectId), null, null, toRefId);
                    } else {
                        LogCommand lc = git.log();
                        lc.add((AnyObjectId)toObjectId);
                        lc.setMaxCount(this.commitsSize);
                        Iterable commits = lc.call();
                        log = new Log(this.cloneLocation, db, commits, null, null, toRefId);
                    }
                    log.setPaging(1, this.commitsSize);
                    children.put((Object)branch.toJSON(log.toJSON()));
                }
                ++i;
            }
            result.put("Children", (Object)children);
            result.put("Type", (Object)"Branch");
            ServerStatus serverStatus = new ServerStatus(Status.OK_STATUS, 200, result);
            return serverStatus;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when listing branches for {0}", (Object)this.path);
            Status status = new Status(4, "org.eclipse.orion.server.git", msg, (Throwable)e);
            return status;
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }
}

