/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.gerritfs;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.orion.server.gerritfs.IURIUnqualificationStrategy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class JsonURIUnqualificationStrategy
implements IURIUnqualificationStrategy {
    public static final IURIUnqualificationStrategy ALL = new JsonURIUnqualificationStrategy(){

        @Override
        protected URI unqualifyObjectProperty(String key, URI uri, String scheme, String hostname, int port) {
            return 1.unqualifyURI(uri, scheme, hostname, port);
        }

        @Override
        protected URI unqualifyArrayValue(int index, URI uri, String scheme, String hostname, int port) {
            return 1.unqualifyURI(uri, scheme, hostname, port);
        }

        @Override
        public String getName() {
            return "ALL";
        }
    };
    public static final IURIUnqualificationStrategy LOCATION_ONLY = new JsonURIUnqualificationStrategy(){

        @Override
        protected URI unqualifyObjectProperty(String key, URI uri, String scheme, String hostname, int port) {
            if (!"Location".equals(key)) {
                return uri;
            }
            return 2.unqualifyURI(uri, scheme, hostname, port);
        }

        @Override
        protected URI unqualifyArrayValue(int index, URI uri, String scheme, String hostname, int port) {
            return uri;
        }

        @Override
        public String getName() {
            return "LOCATION_ONLY";
        }
    };
    public static final IURIUnqualificationStrategy ALL_NO_GIT = new JsonURIUnqualificationStrategy(){

        @Override
        protected URI unqualifyObjectProperty(String key, URI uri, String scheme, String hostname, int port) {
            if ("GitUrl".equals(key)) {
                return uri;
            }
            return 3.unqualifyURI(uri, scheme, hostname, port);
        }

        @Override
        protected URI unqualifyArrayValue(int index, URI uri, String scheme, String hostname, int port) {
            return uri;
        }

        @Override
        public String getName() {
            return "ALL_NO_GIT";
        }
    };

    @Override
    public void run(HttpServletRequest req, Object result) {
        this.rewrite(result, req.getScheme(), req.getServerName(), req.getServerPort(), req.getContextPath());
    }

    private void rewrite(JSONObject json, String scheme, String hostname, int port, String contextPath) {
        String[] names = JSONObject.getNames(json);
        if (names == null) {
            return;
        }
        for (String name : names) {
            Object o = json.opt(name);
            if (o instanceof URI) {
                try {
                    URI uri = (URI)o;
                    if ("orion".equals(uri.getScheme())) {
                        uri = new URI(null, null, contextPath + uri.getPath(), uri.getQuery(), uri.getFragment());
                    }
                    json.put(name, this.unqualifyObjectProperty(name, uri, scheme, hostname, port));
                }
                catch (JSONException e) {
                }
                catch (URISyntaxException e) {}
                continue;
            }
            if (o instanceof String) {
                String string = (String)o;
                if (!string.startsWith(scheme) && !string.startsWith("orion:/")) continue;
                try {
                    URI uri = new URI(string);
                    uri = "orion".equals(uri.getScheme()) ? new URI(null, null, contextPath + uri.getPath(), uri.getQuery(), uri.getFragment()) : new URI(uri.getScheme(), null, contextPath + uri.getPath(), uri.getQuery(), uri.getFragment());
                    json.put(name, this.unqualifyObjectProperty(name, uri, scheme, hostname, port));
                }
                catch (JSONException e) {
                }
                catch (URISyntaxException e) {}
                continue;
            }
            this.rewrite(o, scheme, hostname, port, contextPath);
        }
    }

    private void rewrite(Object o, String scheme, String hostname, int port, String contextPath) {
        if (o instanceof JSONObject) {
            this.rewrite((JSONObject)o, scheme, hostname, port, contextPath);
        } else if (o instanceof JSONArray) {
            JSONArray a = (JSONArray)o;
            for (int i = 0; i < a.length(); ++i) {
                Object v = a.opt(i);
                if (v instanceof URI) {
                    try {
                        a.put(i, this.unqualifyArrayValue(i, (URI)v, scheme, hostname, port));
                    }
                    catch (JSONException e) {}
                    continue;
                }
                if (v instanceof String) {
                    String string = (String)v;
                    if (!string.startsWith(scheme)) continue;
                    try {
                        a.put(i, this.unqualifyArrayValue(i, new URI(string), scheme, hostname, port));
                    }
                    catch (JSONException e) {
                    }
                    catch (URISyntaxException e) {}
                    continue;
                }
                this.rewrite(v, scheme, hostname, port, contextPath);
            }
        }
    }

    protected abstract URI unqualifyObjectProperty(String var1, URI var2, String var3, String var4, int var5);

    protected abstract URI unqualifyArrayValue(int var1, URI var2, String var3, String var4, int var5);

    protected static URI unqualifyURI(URI uri, String scheme, String hostname, int port) {
        URI simpleURI = uri;
        int uriPort = uri.getPort();
        if (uriPort == -1) {
            uriPort = JsonURIUnqualificationStrategy.getDefaultPort(uri.getScheme());
        }
        if (scheme.equals(uri.getScheme()) && hostname.equals(uri.getHost()) && port == uriPort) {
            try {
                simpleURI = new URI(null, null, null, -1, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                simpleURI = uri;
            }
        }
        try {
            simpleURI = new URI(scheme, null, hostname, port, uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            simpleURI = uri;
        }
        return simpleURI;
    }

    private static int getDefaultPort(String scheme) {
        if ("http".equalsIgnoreCase(scheme)) {
            return 80;
        }
        if ("https".equalsIgnoreCase(scheme)) {
            return 443;
        }
        return -1;
    }
}

