/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.StashApplyFailureException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;

public class StashApplyCommand
extends GitCommand<ObjectId> {
    private static final String DEFAULT_REF = "stash@{0}";
    private String stashRef;
    private boolean applyIndex = true;
    private boolean applyUntracked = true;
    private boolean ignoreRepositoryState;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;

    public StashApplyCommand(Repository repo) {
        super(repo);
    }

    public StashApplyCommand setStashRef(String stashRef) {
        this.stashRef = stashRef;
        return this;
    }

    public StashApplyCommand ignoreRepositoryState(boolean ignoreRepositoryState) {
        this.ignoreRepositoryState = ignoreRepositoryState;
        return this;
    }

    private ObjectId getStashId() throws GitAPIException {
        ObjectId stashId;
        String revision = this.stashRef != null ? this.stashRef : DEFAULT_REF;
        try {
            stashId = this.repo.resolve(revision);
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().stashResolveFailed, revision), (Throwable)e);
        }
        if (stashId == null) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().stashResolveFailed, revision));
        }
        return stashId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectId call() throws GitAPIException, WrongRepositoryStateException, NoHeadException, StashApplyFailureException {
        this.checkCallable();
        if (!this.ignoreRepositoryState && this.repo.getRepositoryState() != RepositoryState.SAFE) {
            throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().stashApplyOnUnsafeRepository, this.repo.getRepositoryState()));
        }
        ObjectReader reader = this.repo.newObjectReader();
        try {
            boolean ok;
            RevWalk revWalk = new RevWalk(reader);
            ObjectId headCommit = this.repo.resolve("HEAD");
            if (headCommit == null) {
                throw new NoHeadException(JGitText.get().stashApplyWithoutHead);
            }
            ObjectId stashId = this.getStashId();
            RevCommit stashCommit = revWalk.parseCommit((AnyObjectId)stashId);
            if (stashCommit.getParentCount() < 2 || stashCommit.getParentCount() > 3) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().stashCommitIncorrectNumberOfParents, stashId.name(), stashCommit.getParentCount()));
            }
            ObjectId headTree = this.repo.resolve("HEAD^{tree}");
            RevCommit stashIndexCommit = revWalk.parseCommit((AnyObjectId)stashCommit.getParent(1));
            RevCommit stashHeadCommit = stashCommit.getParent(0);
            RevCommit untrackedCommit = null;
            if (this.applyUntracked && stashCommit.getParentCount() == 3) {
                untrackedCommit = revWalk.parseCommit((AnyObjectId)stashCommit.getParent(2));
            }
            ResolveMerger merger = (ResolveMerger)this.strategy.newMerger(this.repo);
            merger.setCommitNames(new String[]{"stashed HEAD", "HEAD", "stash"});
            merger.setBase((AnyObjectId)stashHeadCommit);
            merger.setWorkingTreeIterator((WorkingTreeIterator)new FileTreeIterator(this.repo));
            if (!merger.merge(new AnyObjectId[]{headCommit, stashCommit})) throw new StashApplyFailureException(JGitText.get().stashApplyConflict);
            DirCache dc = this.repo.lockDirCache();
            DirCacheCheckout dco = new DirCacheCheckout(this.repo, headTree, dc, merger.getResultTreeId());
            dco.setFailOnConflict(true);
            dco.checkout();
            if (this.applyIndex) {
                ResolveMerger ixMerger = (ResolveMerger)this.strategy.newMerger(this.repo, true);
                ixMerger.setCommitNames(new String[]{"stashed HEAD", "HEAD", "stashed index"});
                ixMerger.setBase((AnyObjectId)stashHeadCommit);
                ok = ixMerger.merge(new AnyObjectId[]{headCommit, stashIndexCommit});
                if (!ok) throw new StashApplyFailureException(JGitText.get().stashApplyConflict);
                this.resetIndex(revWalk.parseTree((AnyObjectId)ixMerger.getResultTreeId()));
            }
            if (untrackedCommit != null) {
                ResolveMerger untrackedMerger = (ResolveMerger)this.strategy.newMerger(this.repo, true);
                untrackedMerger.setCommitNames(new String[]{"stashed HEAD", "HEAD", "untracked files"});
                untrackedMerger.setBase((AnyObjectId)stashHeadCommit);
                ok = untrackedMerger.merge(new AnyObjectId[]{stashHeadCommit, untrackedCommit});
                if (!ok) throw new StashApplyFailureException(JGitText.get().stashApplyConflict);
                try {
                    RevTree untrackedTree = revWalk.parseTree((AnyObjectId)untrackedMerger.getResultTreeId());
                    this.resetUntracked(untrackedTree);
                }
                catch (CheckoutConflictException checkoutConflictException) {
                    throw new StashApplyFailureException(JGitText.get().stashApplyConflict);
                }
            }
            ObjectId objectId = stashId;
            return objectId;
        }
        catch (JGitInternalException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().stashApplyFailed, (Throwable)e);
        }
        finally {
            reader.release();
        }
    }

    public void setApplyIndex(boolean applyIndex) {
        this.applyIndex = applyIndex;
    }

    public StashApplyCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public void setApplyUntracked(boolean applyUntracked) {
        this.applyUntracked = applyUntracked;
    }

    private void resetIndex(RevTree tree) throws IOException {
        DirCache dc = this.repo.lockDirCache();
        TreeWalk walk = null;
        try {
            DirCacheBuilder builder = dc.builder();
            walk = new TreeWalk(this.repo);
            walk.addTree((AnyObjectId)tree);
            walk.addTree((AbstractTreeIterator)new DirCacheIterator(dc));
            walk.setRecursive(true);
            while (walk.next()) {
                AbstractTreeIterator cIter = walk.getTree(0, AbstractTreeIterator.class);
                if (cIter == null) continue;
                DirCacheEntry entry = new DirCacheEntry(walk.getRawPath());
                entry.setFileMode(cIter.getEntryFileMode());
                entry.setObjectIdFromRaw(cIter.idBuffer(), cIter.idOffset());
                DirCacheIterator dcIter = (DirCacheIterator)walk.getTree(1, DirCacheIterator.class);
                if (dcIter != null && dcIter.idEqual(cIter)) {
                    DirCacheEntry indexEntry = dcIter.getDirCacheEntry();
                    entry.setLastModified(indexEntry.getLastModified());
                    entry.setLength(indexEntry.getLength());
                }
                builder.add(entry);
            }
            builder.commit();
        }
        finally {
            dc.unlock();
            if (walk != null) {
                walk.release();
            }
        }
    }

    private void resetUntracked(RevTree tree) throws CheckoutConflictException, IOException {
        TreeWalk walk = null;
        try {
            walk = new TreeWalk(this.repo);
            walk.addTree((AnyObjectId)tree);
            walk.addTree((AbstractTreeIterator)new FileTreeIterator(this.repo));
            walk.setRecursive(true);
            ObjectReader reader = walk.getObjectReader();
            while (walk.next()) {
                AbstractTreeIterator cIter = walk.getTree(0, AbstractTreeIterator.class);
                if (cIter == null) continue;
                DirCacheEntry entry = new DirCacheEntry(walk.getRawPath());
                entry.setFileMode(cIter.getEntryFileMode());
                entry.setObjectIdFromRaw(cIter.idBuffer(), cIter.idOffset());
                FileTreeIterator fIter = (FileTreeIterator)walk.getTree(1, FileTreeIterator.class);
                if (fIter != null && fIter.isModified(entry, true, reader)) {
                    throw new CheckoutConflictException(entry.getPathString());
                }
                this.checkoutPath(entry, reader);
            }
        }
        finally {
            if (walk != null) {
                walk.release();
            }
        }
    }

    private void checkoutPath(DirCacheEntry entry, ObjectReader reader) {
        try {
            File file = new File(this.repo.getWorkTree(), entry.getPathString());
            DirCacheCheckout.checkoutEntry((Repository)this.repo, (File)file, (DirCacheEntry)entry, (ObjectReader)reader);
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutConflictWithFile, entry.getPathString()), (Throwable)e);
        }
    }
}

