### Creating Tern index files

Orion provides JSON type definition files (http://ternjs.net/doc/manual.html#typedef) otherwise known as indexes for a number of common libraries.
This file goes over the steps used to generate them.  Note that the Tern plugins contain the templates as well as the JSON type def.

### Install Node and NPM

You need to run the Tern server from the command line as a Node.js server.  NPM will make it simpler to install Tern and the source to index.

### Install Tern

	npm install tern@0.6.2

This will install tern inside the node_modules directory of the directory you are currently in.  The @0.6.2 specifies a version of Tern to install.
The version you use should match the version of Tern Orion is using.  It is unknown whether indexes generated by later versions are backwards compatible.

If in the steps below the node Tern server cannot find modules such as acorn/acorn, you will have to modify the scripts to use the new paths (Tern's depends on 
acorn and other scripts which have changed folder structure).  You can simply compare the scripts to the latest version of Tern on github (https://github.com/marijnh/tern)
or fix them manually ('acorn/acorn' becomes 'acorn', etc.)

### Get the source

You can use git command line, find the github page for your source and clone the repo.  Or you can use npm install to get the source.


### Run the Tern Condense utility

	node tern/bin/condense --name redis --no-spans --plugin doc_comment --def ecma5 --def browser redis/lib/*.js redis/lib/parser/*.js redis/*.js > redis.json
	node tern/bin/condense --name amqp --no-spans --plugin doc_comment --def ecma5 --def browser ../node-amqp/lib/*.js ../node-amqp/*.js > amqp.json
	node tern/bin/condense --name express --no-spans --plugin doc_comment --def ecma5 --def browser ../express/lib/*.js ../express/lib/middleware/*.js ../express/lib/router/*.js ../express/*.js > express.json
	node tern/bin/condense --name mysql --no-spans --plugin doc_comment --def ecma5 --def browser ../node-mysql/lib/*.js ../node-mysql/lib/protocol/*.js ../node-mysql/lib/protocol/constants/*.js ../node-mysql/lib/protocol/packets/*.js ../node-mysql/lib/protocol/sequences/*.js ../node-mysql/*.js > mysql.json
	node tern/bin/condense --name mongodb --no-spans --plugin doc_comment --def ecma5 --def browser ../node-mongodb-native/lib/bulk/*.js ../node-mongodb-native/lib/gridfs/*.js ../node-mongodb-native/lib/*.js ../node-mongodb-native/*.js > mongodb.json
	node tern/bin/condense --name postgres --no-spans --plugin doc_comment --def ecma5 --def browser ../node-postgres/lib/native/*.js ../node-postgres/lib/*.js > postgres
	
From the node_modules folder where you installed Tern, run the tern condense utility with appropriate arguments.  You will have to adjust the file list to
where you downloaded the source.  Because Win cmd can't handle wildcard file lists, you will need Cygwin or Git Bash to execute successfully on Windows.	

### Indexes we provide

	'tern/plugin/orionAMQP',
	'tern/plugin/orionAngular',
	'tern/plugin/orionComponent',
	'tern/plugin/orionExpress',	
	'tern/plugin/orionMongoDB',
	'tern/plugin/orionMySQL',	
	'tern/plugin/orionNode',
	'tern/plugin/orionPostgres',
	'tern/plugin/orionRedis',
	'tern/plugin/orionRequire',