/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.orion.server.cf.ExpiryCache;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.OrgWithSpaces;
import org.eclipse.orion.server.cf.objects.Space;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetOrgsCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private static final int CACHE_EXPIRES_MS = 300000;
    private static final int MAX_CACHE_SIZE = 1000;
    private String commandName;
    private String userId;
    static ExpiryCache<JSONObject> orgsCache = new ExpiryCache(1000, 300000);
    static Set<List<Object>> check = new HashSet<List<Object>>();

    public GetOrgsCommand(String userId, Target target) {
        super(target);
        this.userId = userId;
        this.commandName = "Get Spaces";
    }

    @Override
    protected ServerStatus _doIt() {
        final List<Object> key = Arrays.asList(this.target, this.userId);
        JSONObject cachedOrgs = orgsCache.get(key);
        if (cachedOrgs != null) {
            if (!check.contains(key)) {
                this.logger.debug(NLS.bind((String)"Need to validate {1} cache for user {0}", (Object)this.userId, (Object)this.target.getUrl().toString()));
                new Job("Validating cache"){

                    protected IStatus run(IProgressMonitor monitor) {
                        GetOrgsCommand.this.logger.debug(NLS.bind((String)"Validating {1} cache for user {0}", (Object)GetOrgsCommand.this.userId, (Object)GetOrgsCommand.this.target.getUrl().toString()));
                        check.add(key);
                        ServerStatus getOrgsSatus = GetOrgsCommand.this.getOrgs();
                        check.remove(key);
                        GetOrgsCommand.this.logger.debug(NLS.bind((String)"Validation for {1} cache for user {0} finished", (Object)GetOrgsCommand.this.userId, (Object)GetOrgsCommand.this.target.getUrl().toString()));
                        return getOrgsSatus;
                    }
                }.schedule();
            }
            this.logger.debug(NLS.bind((String)"Geting orgs from {1} cache for user {0}", (Object)this.userId, (Object)this.target.getUrl().toString()));
            return new ServerStatus(Status.OK_STATUS, 200, cachedOrgs);
        }
        return this.getOrgs();
    }

    private ServerStatus getOrgs() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            URI orgsURI = targetURI.resolve("/v2/organizations");
            GetMethod getOrgsMethod = new GetMethod(orgsURI.toString());
            ServerStatus confStatus = HttpUtil.configureHttpMethod((HttpMethod)getOrgsMethod, this.target.getCloud());
            if (!confStatus.isOK()) {
                return confStatus;
            }
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add(new NameValuePair("inline-relations-depth", "1"));
            if (this.target.getCloud().getRegion() != null) {
                params.add(new NameValuePair("region", this.target.getCloud().getRegion()));
            }
            getOrgsMethod.setQueryString(params.toArray(new NameValuePair[params.size()]));
            ServerStatus getOrgsStatus = HttpUtil.executeMethod((HttpMethodBase)getOrgsMethod);
            if (!getOrgsStatus.isOK() && getOrgsStatus.getHttpCode() != 206) {
                return getOrgsStatus;
            }
            JSONObject orgs = getOrgsStatus.getJsonData();
            if (orgs == null || orgs.optInt("total_results", 0) < 1) {
                return new ServerStatus(4, 204, "Server did not return any organizations.", null);
            }
            JSONObject result = new JSONObject();
            int resources = orgs.getJSONArray("resources").length();
            int k = 0;
            while (k < resources) {
                ArrayList<Space> spaces = new ArrayList<Space>();
                JSONObject orgJSON = orgs.getJSONArray("resources").getJSONObject(k);
                ServerStatus getSpacesStatus = this.getSpaces(spaces, orgJSON);
                if (!getSpacesStatus.isOK()) {
                    return getSpacesStatus;
                }
                OrgWithSpaces orgWithSpaces = new OrgWithSpaces();
                orgWithSpaces.setCFJSON(orgJSON);
                orgWithSpaces.setSpaces(spaces);
                result.append("Orgs", (Object)orgWithSpaces.toJSON());
                ++k;
            }
            List<Object> key = Arrays.asList(this.target, this.userId);
            orgsCache.put(key, result);
            return new ServerStatus(Status.OK_STATUS, 200, result);
        }
        catch (ConnectTimeoutException e) {
            String msg = NLS.bind((String)"An error occurred when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 504, msg, (Throwable)e);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occurred when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }

    private ServerStatus getSpaces(List<Space> spaces, JSONObject orgJSON) throws Exception {
        long time = System.currentTimeMillis();
        URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
        URI spaceURI = targetURI.resolve(orgJSON.getJSONObject("entity").getString("spaces_url"));
        GetMethod getDomainsMethod = new GetMethod(spaceURI.toString());
        ServerStatus confStatus = HttpUtil.configureHttpMethod((HttpMethod)getDomainsMethod, this.target.getCloud());
        if (!confStatus.isOK()) {
            return confStatus;
        }
        getDomainsMethod.setQueryString("inline-relations-depth=1");
        ServerStatus status = HttpUtil.executeMethod((HttpMethodBase)getDomainsMethod);
        if (!status.isOK()) {
            return status;
        }
        JSONObject orgs = status.getJsonData();
        if (orgs.getInt("total_results") < 1) {
            return new ServerStatus(Status.OK_STATUS, 200);
        }
        int resources = orgs.getJSONArray("resources").length();
        int k = 0;
        while (k < resources) {
            JSONObject spaceJSON = orgs.getJSONArray("resources").getJSONObject(k);
            spaces.add(new Space().setCFJSON(spaceJSON));
            ++k;
        }
        this.logger.debug("GetOrgsCommand: getting spaces using " + spaceURI + " took " + (System.currentTimeMillis() - time));
        return new ServerStatus(Status.OK_STATUS, 200);
    }
}

