/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.logs.jobs;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.FileAppender;
import java.net.URI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.TaskJob;
import org.eclipse.orion.server.logs.ILogService;
import org.eclipse.orion.server.logs.objects.FileAppenderResource;
import org.eclipse.osgi.util.NLS;

public class FileAppenderJob
extends TaskJob {
    private final ILogService logService;
    private final URI baseLocation;
    private final String appenderName;

    public FileAppenderJob(String userRunningTask, ILogService logService, URI baseLocation, String appenderName) {
        super(userRunningTask, false);
        this.logService = logService;
        this.baseLocation = baseLocation;
        this.appenderName = appenderName;
    }

    protected IStatus performJob() {
        try {
            FileAppender<ILoggingEvent> appender = this.logService.getFileAppender(this.appenderName);
            if (appender == null) {
                String msg = NLS.bind((String)"Appender not found: {0}", (Object)this.appenderName);
                return new ServerStatus(4, 404, msg, null);
            }
            FileAppenderResource fileAppender = new FileAppenderResource(appender, this.baseLocation);
            return new ServerStatus(Status.OK_STATUS, 200, fileAppender.toJSON());
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when looking for appender: {0}", (Object)this.appenderName);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

