/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.manifest.v2.utils.ManifestUtils;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindRouteCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private App application;
    private String domainGUID;
    private String appHost;
    private String commandName;

    public String getAppHost() {
        return this.appHost;
    }

    protected FindRouteCommand(Target target, App app, String domainGUID) {
        super(target);
        this.application = app;
        this.domainGUID = domainGUID;
        Object[] bindings = new String[]{domainGUID};
        this.commandName = NLS.bind((String)"Find route within the given domain ({0})", (Object[])bindings);
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            URI routesURI = targetURI.resolve("/v2/routes");
            GetMethod findRouteMethod = new GetMethod(routesURI.toString());
            ServerStatus confStatus = HttpUtil.configureHttpMethod((HttpMethod)findRouteMethod, this.target.getCloud());
            if (!confStatus.isOK()) {
                return confStatus;
            }
            findRouteMethod.setQueryString("inline-relations-depth=1&q=host:" + this.appHost + ";domain_guid:" + this.domainGUID);
            ServerStatus status = HttpUtil.executeMethod((HttpMethodBase)findRouteMethod);
            if (!status.isOK()) {
                return status;
            }
            JSONObject response = status.getJsonData();
            if (response.getInt("total_results") < 1) {
                return new ServerStatus(4, 404, "Route not found", null);
            }
            JSONArray resources = response.getJSONArray("resources");
            JSONObject route = resources.getJSONObject(0);
            return new ServerStatus(Status.OK_STATUS, 200, route);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }

    @Override
    protected IStatus validateParams() {
        try {
            ManifestParseTree manifest = this.application.getManifest();
            ManifestParseTree app = manifest.get("applications").get(0);
            String appName = null;
            appName = this.application.getName() != null ? this.application.getName() : app.get("name").getValue();
            ManifestParseTree hostNode = app.getOpt("host");
            String string = this.appHost = hostNode != null ? hostNode.getValue() : ManifestUtils.slugify(appName);
            if (this.appHost != null) {
                return Status.OK_STATUS;
            }
            return new ServerStatus(4, 404, "Route not found", null);
        }
        catch (InvalidAccessException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
    }
}

