/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.Cloud;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetInfoCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Get Info";

    public GetInfoCommand(Cloud cloud) {
        super(cloud);
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            URI infoURI = URIUtil.toURI((URL)this.getCloud().getUrl()).resolve("/v2/info");
            GetMethod getInfoMethod = new GetMethod(infoURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)getInfoMethod, this.getCloud());
            ServerStatus status = HttpUtil.executeMethod((HttpMethodBase)getInfoMethod);
            return status;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occurred when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }

    @Override
    protected ServerStatus retryIfNeeded(ServerStatus doItStatus) {
        return doItStatus;
    }
}

