/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.gerritfs;

import com.google.gerrit.extensions.annotations.Export;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.AccessPath;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.AuthRequest;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Export(value="/list/*")
@Singleton
public class GerritListFile
extends HttpServlet {
    private final GitRepositoryManager repoManager;
    private final ProjectControl.Factory projControlFactory;
    private final Provider<WebSession> session;
    private final AccountCache accountCache;
    private final Config config;
    private final AccountManager accountManager;
    private static Logger log = LoggerFactory.getLogger(GerritListFile.class);

    @Inject
    public GerritListFile(GitRepositoryManager repoManager, ProjectControl.Factory project, Provider<WebSession> session, AccountCache accountCache, @GerritServerConfig Config config, AccountManager accountManager) {
        this.repoManager = repoManager;
        this.projControlFactory = project;
        this.session = session;
        this.accountCache = accountCache;
        this.config = config;
        this.accountManager = accountManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block28: {
            this.handleAuth(req);
            resp.setCharacterEncoding("UTF-8");
            PrintWriter out = resp.getWriter();
            try {
                String pathInfo = req.getPathInfo();
                Pattern pattern = Pattern.compile("/([^/]*)(?:/([^/]*)(?:/(.*))?)?");
                Matcher matcher = pattern.matcher(pathInfo);
                matcher.matches();
                String projectName = null;
                String refName = null;
                String filePath = null;
                if (matcher.groupCount() > 0) {
                    projectName = matcher.group(1);
                    refName = matcher.group(2);
                    filePath = matcher.group(3);
                    projectName = projectName == null || projectName.equals("") ? null : URLDecoder.decode(projectName, "UTF-8");
                    refName = refName == null || refName.equals("") ? null : URLDecoder.decode(refName, "UTF-8");
                    filePath = filePath == null || filePath.equals("") ? null : URLDecoder.decode(filePath, "UTF-8");
                }
                if (projectName == null) break block28;
                if (filePath == null) {
                    filePath = "";
                }
                Project.NameKey projName = Project.NameKey.parse((String)projectName);
                try {
                    ProjectControl control = this.projControlFactory.controlFor(projName);
                    if (!control.isVisible()) {
                        log.debug("Project not visible!");
                        resp.sendError(401, "You need to be logged in to see private projects");
                        return;
                    }
                }
                catch (NoSuchProjectException e1) {
                    // empty catch block
                }
                Repository repo = this.repoManager.openRepository(projName);
                if (refName == null) {
                    JSONArray contents = new JSONArray();
                    try {
                        List call = new Git(repo).branchList().call();
                        Git git = new Git(repo);
                        for (Ref ref : call) {
                            JSONObject jsonObject = new JSONObject();
                            try {
                                jsonObject.put("name", ref.getName());
                                jsonObject.put("type", "ref");
                                jsonObject.put("size", "0");
                                jsonObject.put("path", "");
                                jsonObject.put("project", projectName);
                                jsonObject.put("ref", ref.getName());
                                GerritListFile.lastCommit(git, null, (AnyObjectId)ref.getObjectId(), jsonObject);
                            }
                            catch (JSONException e) {
                                // empty catch block
                            }
                            contents.put(jsonObject);
                        }
                        String response = contents.toString();
                        resp.setContentType("application/json");
                        resp.setHeader("Cache-Control", "no-cache");
                        resp.setHeader("ETag", "W/\"" + response.length() + "-" + response.hashCode() + "\"");
                        log.debug(response);
                        out.write(response);
                    }
                    catch (GitAPIException e) {}
                    break block28;
                }
                Ref head = repo.getRef(refName);
                if (head == null) {
                    JSONArray contents = new JSONArray();
                    String response = contents.toString();
                    resp.setContentType("application/json");
                    resp.setHeader("Cache-Control", "no-cache");
                    resp.setHeader("ETag", "W/\"" + response.length() + "-" + response.hashCode() + "\"");
                    log.debug(response);
                    out.write(response);
                    return;
                }
                RevWalk walk = new RevWalk(repo);
                Git git = new Git(repo);
                RevCommit commit = walk.parseCommit((AnyObjectId)head.getObjectId());
                RevTree tree = commit.getTree();
                TreeWalk treeWalk = new TreeWalk(repo);
                treeWalk.addTree((AnyObjectId)tree);
                treeWalk.setRecursive(false);
                if (!filePath.equals("")) {
                    PathFilter pathFilter = PathFilter.create((String)filePath);
                    treeWalk.setFilter((TreeFilter)pathFilter);
                }
                if (!treeWalk.next()) {
                    CanonicalTreeParser canonicalTreeParser = (CanonicalTreeParser)treeWalk.getTree(0, CanonicalTreeParser.class);
                    JSONArray contents = new JSONArray();
                    if (canonicalTreeParser != null) {
                        while (!canonicalTreeParser.eof()) {
                            String path = canonicalTreeParser.getEntryPathString();
                            FileMode mode = canonicalTreeParser.getEntryFileMode();
                            GerritListFile.listEntry(path, mode.equals(FileMode.TREE) ? "dir" : "file", "0", path, projectName, head.getName(), repo, git, contents);
                            canonicalTreeParser.next();
                        }
                    }
                    String response = contents.toString();
                    resp.setContentType("application/json");
                    resp.setHeader("Cache-Control", "no-cache");
                    resp.setHeader("ETag", "\"" + tree.getId().getName() + "\"");
                    log.debug(response);
                    out.write(response);
                } else {
                    JSONArray contents = GerritListFile.getListEntries(treeWalk, repo, git, head, filePath, projectName);
                    String response = contents.toString();
                    resp.setContentType("application/json");
                    resp.setHeader("Cache-Control", "no-cache");
                    resp.setHeader("ETag", "\"" + tree.getId().getName() + "\"");
                    log.debug(response);
                    out.write(response);
                }
                walk.release();
                treeWalk.release();
            }
            catch (RepositoryNotFoundException e) {
                this.handleException(resp, (Exception)((Object)e), 400);
            }
            catch (MissingObjectException e) {
                log.error(e.getMessage(), (Throwable)e);
                String msg = e.getMessage() + ".  This exception could have been caused by the use of a git submodule, " + "which is currently not supported by the repository browser.";
                this.handleException(resp, new Exception(msg), 501);
            }
            catch (IOException e) {
                this.handleException(resp, e, 500);
            }
            finally {
                out.close();
            }
        }
    }

    private static void listEntry(String name, String type, String size, String path, String projectName, String ref, Repository repo, Git git, JSONArray contents) throws IOException {
        JSONObject jsonObject = new JSONObject();
        try {
            ObjectId refId = repo.resolve(ref);
            jsonObject.put("name", name);
            jsonObject.put("type", type);
            jsonObject.put("size", size);
            jsonObject.put("path", path);
            jsonObject.put("project", projectName);
            jsonObject.put("ref", ref);
            GerritListFile.lastCommit(git, path, (AnyObjectId)refId, jsonObject);
        }
        catch (JSONException e) {
            // empty catch block
        }
        contents.put(jsonObject);
    }

    private static void lastCommit(Git git, String path, AnyObjectId revId, JSONObject jsonObject) {
        JSONObject latestCommitObj = new JSONObject();
        JSONObject authorObj = new JSONObject();
        JSONObject committerObj = new JSONObject();
        Iterable log = null;
        try {
            if (revId != null && path != null) {
                log = git.log().add(revId).addPath(path).setMaxCount(1).call();
            } else if (path != null) {
                log = git.log().addPath(path).setMaxCount(1).call();
            } else if (revId != null) {
                log = git.log().add(revId).setMaxCount(1).call();
            }
            for (RevCommit rev : log) {
                PersonIdent committer = rev.getCommitterIdent();
                committerObj.put("Name", committer.getName());
                committerObj.put("Email", committer.getEmailAddress());
                committerObj.put("Date", committer.getWhen().toString());
                PersonIdent author = rev.getAuthorIdent();
                authorObj.put("Name", author.getName());
                String authorEmail = author.getEmailAddress();
                authorObj.put("Email", authorEmail);
                authorObj.put("Date", author.getWhen().toString());
                latestCommitObj.put("Author", authorObj);
                latestCommitObj.put("Committer", committerObj);
                latestCommitObj.put("Message", rev.getFullMessage());
                latestCommitObj.put("SHA1", rev.getId().getName());
                latestCommitObj.put("AvatarURL", GerritListFile.getImageLink(authorEmail));
                jsonObject.put("LastCommit", latestCommitObj);
            }
        }
        catch (GitAPIException e) {
        }
        catch (MissingObjectException e) {
        }
        catch (IncorrectObjectTypeException e) {
        }
        catch (JSONException e) {
            // empty catch block
        }
    }

    private void handleAuth(HttpServletRequest req) {
        String username = req.getRemoteUser();
        if (username != null) {
            if (this.config.getBoolean("auth", "userNameToLowerCase", false)) {
                username = username.toLowerCase(Locale.US);
            }
            log.debug("User name: " + username);
            AccountState who = this.accountCache.getByUsername(username);
            log.debug("AccountState " + who);
            if (who == null && username.matches("^([a-zA-Z0-9][a-zA-Z0-9._-]*[a-zA-Z0-9]|[a-zA-Z0-9])$")) {
                log.debug("User is not registered with Gerrit. Register now.");
                AuthRequest areq = AuthRequest.forUser((String)username);
                try {
                    this.accountManager.authenticate(areq);
                    who = this.accountCache.getByUsername(username);
                    if (who == null) {
                        log.warn("Unable to register user \"" + username + "\". Continue as anonymous.");
                    } else {
                        log.debug("User registered.");
                    }
                }
                catch (AccountException e) {
                    log.warn("Exception registering user \"" + username + "\". Continue as anonymous.", (Throwable)e);
                }
            }
            if (who != null && who.getAccount().isActive()) {
                log.debug("Not anonymous user");
                WebSession ws = (WebSession)this.session.get();
                ws.setUserAccountId(who.getAccount().getId());
                ws.setAccessPathOk(AccessPath.REST_API, true);
            } else {
                log.debug("Anonymous user");
            }
        }
    }

    private void handleException(HttpServletResponse resp, Exception e, int status) throws IOException {
        log.error(e.getMessage());
        PrintWriter out = resp.getWriter();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("Severity", "Error");
            jsonObject.put("Message", e.getMessage());
        }
        catch (JSONException e1) {
            // empty catch block
        }
        String response = jsonObject.toString();
        resp.setStatus(status);
        resp.setContentType("application/json");
        out.write(response);
        out.flush();
    }

    public static String getImageLink(String emailAddress) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        digest.update(emailAddress.trim().toLowerCase().getBytes());
        byte[] digestValue = digest.digest();
        StringBuffer result = new StringBuffer("https://www.gravatar.com/avatar/");
        for (int i = 0; i < digestValue.length; ++i) {
            String current = Integer.toHexString(digestValue[i] & 0xFF);
            if (current.length() == 1) {
                result.append('0');
            }
            result.append(current);
        }
        result.append("?d=mm");
        return result.toString();
    }

    public static JSONArray getListEntries(TreeWalk treeWalk, Repository repo, Git git, Ref head, String filePath, String projectName) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        JSONArray contents = new JSONArray();
        do {
            if (treeWalk.isSubtree()) {
                String test = new String(treeWalk.getRawPath());
                if (test.length() > filePath.length()) {
                    GerritListFile.listEntry(treeWalk.getNameString(), "dir", "0", treeWalk.getPathString(), projectName, head.getName(), repo, git, contents);
                }
                if (test.length() > filePath.length()) continue;
                treeWalk.enterSubtree();
                continue;
            }
            ObjectId objId = treeWalk.getObjectId(0);
            ObjectLoader loader = repo.open((AnyObjectId)objId);
            long size = loader.getSize();
            GerritListFile.listEntry(treeWalk.getNameString(), "file", Long.toString(size), treeWalk.getPathString(), projectName, head.getName(), repo, git, contents);
        } while (treeWalk.next());
        return contents;
    }
}

