/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.eclipse.orion.server.git.BaseToCommitConverter;
import org.eclipse.orion.server.git.objects.GitObject;
import org.eclipse.orion.server.git.objects.Remote;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="Branch")
public class Branch
extends GitObject {
    public static final String RESOURCE = "branch";
    public static final String TYPE = "Branch";
    public static final Comparator<Branch> COMPARATOR = new Comparator<Branch>(){

        @Override
        public int compare(Branch o1, Branch o2) {
            block4: {
                try {
                    if (!o1.isCurrent()) break block4;
                    return -1;
                }
                catch (IOException iOException) {}
            }
            if (o2.isCurrent()) {
                return 1;
            }
            return o1.getTime() < o2.getTime() ? 1 : (o1.getTime() > o2.getTime() ? -1 : o2.getName(true, false).compareTo(o1.getName(true, false)));
        }
    };
    private static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    private Ref ref;

    public Branch(URI cloneLocation, Repository db, Ref ref) {
        super(cloneLocation, db);
        Property[] defaultProperties = new Property[]{new Property("Location"), new Property("CloneLocation"), new Property("Name"), new Property("Location"), new Property("FullName"), new Property("CommitLocation"), new Property("TreeLocation"), new Property("DiffLocation"), new Property("RemoteLocation"), new Property("HeadLocation"), new Property("Current"), new Property("LocalTimeStamp")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
        this.ref = ref;
    }

    @Override
    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }

    @PropertyDescription(name="Current")
    public boolean isCurrent() throws IOException {
        return this.getName(false, false).equals(this.db.getBranch());
    }

    @Override
    protected URI getLocation() throws URISyntaxException {
        return this.createLocation(RESOURCE);
    }

    private URI createLocation(String resource) throws URISyntaxException {
        String shortName = this.getName(false, true);
        Path basePath = new Path(this.cloneLocation.getPath());
        IPath newPath = new Path("/gitapi").append(resource).append(shortName).append(basePath.removeFirstSegments(2));
        return new URI(this.cloneLocation.getScheme(), this.cloneLocation.getUserInfo(), this.cloneLocation.getHost(), this.cloneLocation.getPort(), newPath.toString(), this.cloneLocation.getQuery(), this.cloneLocation.getFragment());
    }

    public JSONObject toJSON(JSONObject log) throws JSONException, URISyntaxException, IOException, CoreException {
        JSONObject result = this.toJSON();
        result.put("Commit", (Object)log);
        return result;
    }

    @PropertyDescription(name="RemoteLocation")
    private JSONArray getRemotes() throws URISyntaxException, JSONException, IOException, CoreException {
        String branchName = Repository.shortenRefName((String)this.ref.getName());
        String remoteName = this.getConfig().getString(RESOURCE, branchName, "remote");
        List remoteConfigs = RemoteConfig.getAllRemoteConfigs((Config)this.getConfig());
        ArrayList<JSONObject> remotes = new ArrayList<JSONObject>();
        for (RemoteConfig remoteConfig : remoteConfigs) {
            if (remoteConfig.getFetchRefSpecs().isEmpty()) continue;
            Remote r = new Remote(this.cloneLocation, this.db, remoteConfig.getName());
            r.setNewBranch(branchName);
            if (remoteConfig.getName().equals(remoteName) || remoteName == null && this.db.resolve("refs/remotes/" + remoteConfig.getName() + "/" + branchName) != null) {
                remotes.add(0, r.toJSON());
                continue;
            }
            remotes.add(r.toJSON());
        }
        JSONArray result = new JSONArray();
        for (JSONObject remote : remotes) {
            result.put((Object)remote);
        }
        return result;
    }

    @PropertyDescription(name="Name")
    private String getName() {
        return this.getName(false, false);
    }

    @PropertyDescription(name="FullName")
    private String getFullName() {
        return this.getName(true, false);
    }

    @PropertyDescription(name="CommitLocation")
    private URI getCommitLocation() throws IOException, URISyntaxException {
        return BaseToCommitConverter.getCommitLocation(this.cloneLocation, this.getName(true, true), BaseToCommitConverter.REMOVE_FIRST_2);
    }

    @PropertyDescription(name="TreeLocation")
    private URI getTreeLocation() throws URISyntaxException {
        return this.createTreeLocation(null);
    }

    @PropertyDescription(name="DiffLocation")
    private URI getDiffLocation() throws IOException, URISyntaxException {
        return this.createLocation("diff");
    }

    @PropertyDescription(name="HeadLocation")
    private URI getHeadLocation() throws IOException, URISyntaxException {
        return BaseToCommitConverter.getCommitLocation(this.cloneLocation, "HEAD", BaseToCommitConverter.REMOVE_FIRST_2);
    }

    public String getName(boolean fullName, boolean encode) {
        String name = this.ref.getName();
        if (!fullName) {
            name = Repository.shortenRefName((String)this.ref.getName());
        }
        if (encode) {
            name = GitUtils.encode(name);
        }
        return name;
    }

    @PropertyDescription(name="LocalTimeStamp")
    private long getLocalTimestamp() {
        return (long)this.getTime() * 1000L;
    }

    public int getTime() {
        RevCommit c = this.parseCommit();
        if (c != null) {
            return c.getCommitTime();
        }
        return 0;
    }

    private URI createTreeLocation(String path) throws URISyntaxException {
        IPath clonePath = new Path(this.cloneLocation.getPath()).removeFirstSegments(2);
        IPath result = new Path("/gitapi").append("tree").append(clonePath).append(GitUtils.encode(this.getName()));
        if (path != null) {
            result.append(path);
        }
        return new URI(this.cloneLocation.getScheme(), this.cloneLocation.getUserInfo(), this.cloneLocation.getHost(), this.cloneLocation.getPort(), result.makeAbsolute().toString(), this.cloneLocation.getQuery(), this.cloneLocation.getFragment());
    }

    private RevCommit parseCommit() {
        ObjectId oid = this.ref.getObjectId();
        if (oid == null) {
            return null;
        }
        RevWalk walk = new RevWalk(this.db);
        try {
            RevCommit revCommit = walk.parseCommit((AnyObjectId)oid);
            return revCommit;
        }
        catch (IOException iOException) {
        }
        finally {
            walk.release();
        }
        return null;
    }

    public String toString() {
        return "Branch [ref=" + this.ref + "]";
    }
}

