/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportHttp;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.git.jobs.EclipseGitProgressTransformer;
import org.eclipse.orion.server.git.jobs.FetchJob;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.osgi.util.NLS;

public class PullJob
extends GitJob {
    private IPath path;
    private String projectName;

    public PullJob(String userRunningTask, CredentialsProvider credentials, Path path, boolean force) {
        super(userRunningTask, true, (GitCredentialsProvider)credentials);
        this.path = path;
        this.projectName = path.lastSegment();
        this.setName(NLS.bind((String)"Pulling {0}", (Object)this.projectName));
        this.setFinalMessage(NLS.bind((String)"Pulling {0} done", (Object)this.projectName));
        this.setTaskExpirationTime(TimeUnit.DAYS.toMillis(7L));
    }

    public PullJob(String userRunningTask, CredentialsProvider credentials, Path path, boolean force, Object cookie) {
        this(userRunningTask, credentials, path, force);
        this.cookie = (Cookie)cookie;
    }

    private IStatus doPull(IProgressMonitor monitor) throws IOException, GitAPIException, CoreException {
        EclipseGitProgressTransformer gitMonitor = new EclipseGitProgressTransformer(monitor);
        Repository db = null;
        try {
            db = FileRepositoryBuilder.create((File)GitUtils.getGitDir(this.path));
            Git git = new Git(db);
            PullCommand pc = git.pull();
            pc.setProgressMonitor((ProgressMonitor)gitMonitor);
            pc.setCredentialsProvider((CredentialsProvider)this.credentials);
            pc.setTransportConfigCallback(new TransportConfigCallback(){

                public void configure(Transport t) {
                    PullJob.this.credentials.setUri(t.getURI());
                    if (t instanceof TransportHttp && PullJob.this.cookie != null) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("Cookie", String.valueOf(PullJob.this.cookie.getName()) + "=" + PullJob.this.cookie.getValue());
                        ((TransportHttp)t).setAdditionalHeaders(map);
                    }
                }
            });
            PullResult pullResult = pc.call();
            if (monitor.isCanceled()) {
                Status status = new Status(8, "org.eclipse.orion.server.git", "Cancelled");
                return status;
            }
            if (pullResult.isSuccessful()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            FetchResult fetchResult = pullResult.getFetchResult();
            IStatus fetchStatus = FetchJob.handleFetchResult(fetchResult);
            if (!fetchStatus.isOK()) {
                IStatus iStatus = fetchStatus;
                return iStatus;
            }
            MergeResult.MergeStatus mergeStatus = pullResult.getMergeResult().getMergeStatus();
            if (!mergeStatus.isSuccessful()) {
                Status status = new Status(4, "org.eclipse.orion.server.git", mergeStatus.name());
                return status;
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return Status.OK_STATUS;
    }

    protected IStatus performJob(IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        try {
            result = this.doPull(monitor);
        }
        catch (IOException e) {
            result = new Status(4, "org.eclipse.orion.server.git", "Pulling error", (Throwable)e);
        }
        catch (CoreException e) {
            result = e.getStatus();
        }
        catch (GitAPIException e) {
            result = this.getGitAPIExceptionStatus(e, "Pulling error");
        }
        catch (JGitInternalException e) {
            return this.getJGitInternalExceptionStatus(e, "Pulling error");
        }
        catch (Exception e) {
            result = new Status(4, "org.eclipse.orion.server.git", "Pulling error", (Throwable)e);
        }
        return result;
    }
}

