/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.dom;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.CompositeElement;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTImageHelper;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Node;

public class ShellElement
extends CompositeElement {
    protected boolean isActive;
    private ShellListener shellListener = new ShellListener(){

        public void shellActivated(ShellEvent e) {
            ShellElement.this.isActive = true;
            ShellElement.this.doApplyStyles();
        }

        public void shellDeactivated(ShellEvent e) {
            ShellElement.this.isActive = false;
            ShellElement.this.doApplyStyles();
        }

        public void shellDeiconified(ShellEvent e) {
        }

        public void shellIconified(ShellEvent e) {
        }

        public void shellClosed(ShellEvent e) {
            ShellElement.this.dispose();
        }
    };

    public ShellElement(Shell shell, CSSEngine engine) {
        super((Composite)shell, engine);
    }

    @Override
    public void initialize() {
        super.initialize();
        Shell shell = this.getShell();
        if (!this.dynamicEnabled) {
            return;
        }
        shell.addShellListener(this.shellListener);
    }

    @Override
    public Node getParentNode() {
        return null;
    }

    private Shell getShell() {
        return (Shell)this.getNativeWidget();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (!this.dynamicEnabled) {
            return;
        }
        Shell shell = this.getShell();
        if (!shell.isDisposed()) {
            shell.removeShellListener(this.shellListener);
        }
    }

    @Override
    public boolean isPseudoInstanceOf(String s) {
        if ("active".equals(s)) {
            return this.isActive;
        }
        if ("swt-parented".equals(s)) {
            return this.getShell().getParent() != null;
        }
        if ("swt-unparented".equals(s)) {
            return this.getShell().getParent() == null;
        }
        return super.isPseudoInstanceOf(s);
    }

    @Override
    public String getAttribute(String attr) {
        if ("title".equals(attr)) {
            String title = this.getShell().getText();
            return title != null ? title : "";
        }
        if ("parentage".equals(attr)) {
            Shell shell = this.getShell();
            Composite parent = shell.getParent();
            if (parent == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            do {
                String id;
                if ((id = WidgetElement.getID((Widget)parent)) == null || id.length() <= 0) continue;
                sb.append(id).append(' ');
            } while ((parent = parent.getParent()) != null);
            return sb.toString().trim();
        }
        return super.getAttribute(attr);
    }

    @Override
    public void reset() {
        CSSSWTImageHelper.restoreDefaultImage(this.getShell());
        super.reset();
    }
}

