/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.LocalizationHelper;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtilities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.views.IViewDescriptor;

public class ViewDescriptor
implements IViewDescriptor,
IPluginContribution {
    private MApplication application;
    private MPartDescriptor descriptor;
    private IConfigurationElement element;
    private String[] categoryPath;
    private ImageDescriptor imageDescriptor;

    public ViewDescriptor(MApplication application, MPartDescriptor descriptor, IConfigurationElement element) {
        this.application = application;
        this.descriptor = descriptor;
        this.element = element;
        String category = descriptor.getCategory();
        if (category != null) {
            this.categoryPath = category.split("/");
        }
    }

    @Override
    public IViewPart createView() throws CoreException {
        if (this.element == null) {
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, "Unable to create an e4 view of id " + this.descriptor.getElementId()));
        }
        return (IViewPart)this.element.createExecutableExtension("class");
    }

    @Override
    public String[] getCategoryPath() {
        return this.categoryPath;
    }

    @Override
    public String getDescription() {
        return this.element == null ? "" : RegistryReader.getDescription(this.element);
    }

    @Override
    public String getId() {
        return this.descriptor.getElementId();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor == null) {
            String iconURI = this.descriptor.getIconURI();
            if (iconURI == null) {
                IWorkbench workbench = (IWorkbench)this.application.getContext().get(IWorkbench.class.getName());
                this.imageDescriptor = workbench.getSharedImages().getImageDescriptor("IMG_DEF_VIEW");
            } else {
                ISWTResourceUtilities utility = (ISWTResourceUtilities)this.application.getContext().get(IResourceUtilities.class.getName());
                this.imageDescriptor = (ImageDescriptor)utility.imageDescriptorFromURI(URI.createURI((String)iconURI));
            }
        }
        return this.imageDescriptor;
    }

    @Override
    public String getLabel() {
        return LocalizationHelper.getLocalized((String)this.descriptor.getLabel(), (MApplicationElement)this.descriptor, (IEclipseContext)this.application.getContext());
    }

    @Override
    public float getFastViewWidthRatio() {
        return 0.0f;
    }

    @Override
    public boolean getAllowMultiple() {
        return this.descriptor.isAllowMultiple();
    }

    @Override
    public boolean isRestorable() {
        if (this.element == null) {
            return false;
        }
        String string = this.element.getAttribute("restorable");
        return string == null ? true : Boolean.parseBoolean(string);
    }

    public Object getAdapter(Class adapter) {
        if (adapter != null && adapter.equals(IConfigurationElement.class)) {
            return this.getConfigurationElement();
        }
        return null;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.element;
    }

    @Override
    public String getLocalId() {
        return this.getId();
    }

    @Override
    public String getPluginId() {
        return this.getConfigurationElement().getNamespaceIdentifier();
    }
}

