/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.net.URI;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.StashCreateCommand;
import org.eclipse.jgit.api.StashDropCommand;
import org.eclipse.jgit.api.StashListCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.jobs.StashApplyCommand;
import org.eclipse.orion.server.git.objects.StashPage;
import org.eclipse.orion.server.git.objects.StashRef;
import org.eclipse.orion.server.git.servlets.AbstractGitHandler;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;

public class GitStashHandlerV1
extends AbstractGitHandler {
    private static final int PAGE_SIZE = 50;

    GitStashHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    protected StashRef getStashRef(Git git, String stashRev) throws InvalidRefNameException, GitAPIException {
        if (stashRev == null) {
            return null;
        }
        StashListCommand stashList = git.stashList();
        Collection stashedRefsCollection = stashList.call();
        int k = 0;
        for (RevCommit rev : stashedRefsCollection) {
            if (stashRev.equals(rev.getName())) {
                return new StashRef(k);
            }
            ++k;
        }
        return null;
    }

    protected boolean isStashEmpty(Git git) throws InvalidRefNameException, GitAPIException {
        StashListCommand stashList = git.stashList();
        Collection stashedRefsCollection = stashList.call();
        return stashedRefsCollection.isEmpty();
    }

    @Override
    protected boolean handlePost(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        JSONObject requestPayload = requestInfo.getJSONRequest();
        HttpServletRequest request = requestInfo.request;
        HttpServletResponse response = requestInfo.response;
        Repository db = requestInfo.db;
        String indexMessage = requestPayload.optString("IndexMessage");
        String workingDirectoryMessage = requestPayload.optString("WorkingDirectoryMessage");
        boolean includeUntracked = requestPayload.optBoolean("IncludeUntracked", false);
        try {
            Git git = new Git(db);
            StashCreateCommand stashCreate = git.stashCreate();
            stashCreate.setPerson(new PersonIdent(db));
            stashCreate.setIncludeUntracked(includeUntracked);
            if (!indexMessage.isEmpty()) {
                stashCreate.setIndexMessage(indexMessage);
            }
            if (!workingDirectoryMessage.isEmpty()) {
                stashCreate.setWorkingDirectoryMessage(workingDirectoryMessage);
            }
            stashCreate.call();
            return true;
        }
        catch (Exception ex) {
            String msg = "An error occured for stash command.";
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)ex));
        }
    }

    @Override
    protected boolean handlePut(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        JSONObject requestPayload = requestInfo.getJSONRequest();
        HttpServletRequest request = requestInfo.request;
        HttpServletResponse response = requestInfo.response;
        Repository db = requestInfo.db;
        String stashRev = requestInfo.gitSegment;
        boolean applyIndex = requestPayload.optBoolean("ApplyIndex", true);
        boolean applyUntracked = requestPayload.optBoolean("ApplyUntracked", true);
        try {
            Git git = new Git(db);
            if (this.isStashEmpty(git)) {
                String msg = "Failed to apply stashed changes due to an empty stash.";
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(2, 400, msg, null));
            }
            StashApplyCommand applyCommand = new StashApplyCommand(db);
            if (stashRev != null) {
                StashRef stashRef = this.getStashRef(git, stashRev);
                if (stashRef == null) {
                    String msg = NLS.bind((String)"Invalid stash reference {0}.", (Object)stashRev);
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
                }
                applyCommand.setStashRef(stashRef.getStringRef());
                applyCommand.setApplyUntracked(applyUntracked);
                applyCommand.setApplyIndex(applyIndex);
                applyCommand.call();
            } else {
                applyCommand.setApplyUntracked(applyUntracked);
                applyCommand.setApplyIndex(applyIndex);
                applyCommand.call();
                StashDropCommand dropCommand = git.stashDrop();
                dropCommand.setAll(false);
                dropCommand.call();
            }
            return true;
        }
        catch (Exception ex) {
            String msg = "An error occured for stash command.";
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)ex));
        }
    }

    @Override
    protected boolean handleGet(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        HttpServletRequest request = requestInfo.request;
        HttpServletResponse response = requestInfo.response;
        Repository db = requestInfo.db;
        int page = request.getParameter("page") != null ? new Integer(request.getParameter("page")) : 1;
        int pageSize = request.getParameter("pageSize") != null ? new Integer(request.getParameter("pageSize")) : 50;
        String messageFilter = request.getParameter("filter");
        try {
            URI baseLocation = GitStashHandlerV1.getURI((HttpServletRequest)request);
            URI cloneLocation = BaseToCloneConverter.getCloneLocation(baseLocation, BaseToCloneConverter.COMMIT);
            Git git = new Git(db);
            StashListCommand stashList = git.stashList();
            Collection stashedRefsCollection = stashList.call();
            StashPage stashPage = new StashPage(cloneLocation, db, stashedRefsCollection, page, pageSize, messageFilter);
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)stashPage.toJSON());
            return true;
        }
        catch (Exception ex) {
            String msg = "An error occured for stash command.";
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)ex));
        }
    }

    @Override
    protected boolean handleDelete(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        HttpServletRequest request = requestInfo.request;
        HttpServletResponse response = requestInfo.response;
        Repository db = requestInfo.db;
        String stashRev = requestInfo.gitSegment;
        try {
            Git git = new Git(db);
            if (this.isStashEmpty(git)) {
                String msg = "Failed to drop stashed changes due to an empty stash.";
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(2, 400, msg, null));
            }
            StashDropCommand dropCommand = git.stashDrop();
            if (stashRev != null) {
                StashRef stashRef = this.getStashRef(git, stashRev);
                if (stashRef == null) {
                    String msg = NLS.bind((String)"Invalid stash reference {0}.", (Object)stashRev);
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
                }
                dropCommand.setStashRef(stashRef.getRef());
            } else {
                dropCommand.setAll(true);
            }
            dropCommand.call();
            return true;
        }
        catch (Exception ex) {
            String msg = "An error occured for stash command.";
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)ex));
        }
    }
}

