/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.orion.server.core.IOUtilities;

public class Packager {
    protected static String CF_IGNORE_FILE = ".cfignore";
    protected HashMap<URI, IgnoreNode> cfIgnore = new HashMap();
    protected IFileStore base;

    public Packager(IFileStore base) {
        this.base = base;
    }

    protected boolean isIgnored(IFileStore source, IPath path, boolean isDirectory) throws CoreException {
        if (!this.base.isParentOf(source) && !this.base.equals(source)) {
            return false;
        }
        IgnoreNode node = this.cfIgnore.get(source.toURI());
        if (node == null) {
            return this.isIgnored(source.getParent(), path, isDirectory);
        }
        IFileStore pathStore = this.base.getFileStore(path);
        URI relativeURI = URIUtil.makeRelative((URI)pathStore.toURI(), (URI)source.toURI());
        switch (node.isIgnored(relativeURI.toString(), isDirectory)) {
            case IGNORED: {
                return true;
            }
            case NOT_IGNORED: {
                return false;
            }
        }
        return this.isIgnored(source.getParent(), path, isDirectory);
    }

    protected void writeZip(IFileStore source, IPath path, ZipOutputStream zos) throws CoreException, IOException {
        IFileInfo info;
        IFileStore cfIgnoreFile = source.getChild(CF_IGNORE_FILE);
        if (cfIgnoreFile.fetchInfo().exists()) {
            IgnoreNode node = new IgnoreNode();
            InputStream is = null;
            try {
                is = cfIgnoreFile.openInputStream(0, null);
                node.parse(is);
                this.cfIgnore.put(source.toURI(), node);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        if ((info = source.fetchInfo(0, null)).isDirectory()) {
            if (!this.isIgnored(source, path, true)) {
                IFileStore[] iFileStoreArray = source.childStores(0, null);
                int n = iFileStoreArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileStore child = iFileStoreArray[n2];
                    this.writeZip(child, path.append(child.getName()), zos);
                    ++n2;
                }
            }
        } else if (!this.isIgnored(source, path, false)) {
            ZipEntry entry = new ZipEntry(path.toString());
            zos.putNextEntry(entry);
            IOUtilities.pipe((InputStream)source.openInputStream(0, null), (OutputStream)zos, (boolean)true, (boolean)false);
        }
    }

    public void writeZip(IFileStore source, ZipOutputStream zos) throws CoreException, IOException {
        this.writeZip(source, (IPath)Path.EMPTY, zos);
    }
}

