/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.utils;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.orion.server.cf.CFExtServiceHelper;
import org.eclipse.orion.server.cf.objects.Cloud;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.URLUtil;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.json.JSONObject;

public class TargetRegistry {
    private Map<String, UserClouds> cloudMap = Collections.synchronizedMap(new HashMap());

    public Target getDefaultTarget(String userId) {
        return this.getTarget(userId, null);
    }

    public Target getTarget(String userId, URL url) {
        UserClouds userClouds = this.getUserClouds(userId);
        return userClouds.getTarget(url);
    }

    public Cloud getCloud(String userId, URL url) {
        UserClouds userClouds = this.getUserClouds(userId);
        return userClouds.getCloud(url);
    }

    public Cloud createTempCloud(URL url) {
        Cloud someCloud;
        CFExtServiceHelper helper = CFExtServiceHelper.getDefault();
        if (helper != null && helper.getService() != null && (someCloud = helper.getService().getClouds(null).get(url)) != null) {
            return new DarkCloud(someCloud, null);
        }
        return new DarkCloud(url, null, null);
    }

    public void setDefaultTarget(String userId, Target target) {
        UserClouds userClouds = this.getUserClouds(userId);
        userClouds.setDefaulTarget(target);
    }

    private UserClouds getUserClouds(String userId) {
        UserClouds userClouds = this.cloudMap.get(userId);
        if (userClouds == null) {
            userClouds = new UserClouds(userId);
            this.cloudMap.put(userId, userClouds);
        }
        return userClouds;
    }

    private class DarkCloud
    extends Cloud {
        protected DarkCloud(URL apiUrl, URL manageUrl, String userId) {
            super(apiUrl, manageUrl, userId);
        }

        protected DarkCloud(String regionId, URL apiUrl, URL manageUrl, String userId) {
            super(regionId, apiUrl, manageUrl, userId);
        }

        protected DarkCloud(Cloud cloud, String userId) {
            super(cloud.getRegion(), cloud.getUrl(), cloud.getManageUrl(), userId);
        }
    }

    private class UserClouds {
        private String userId;
        private Map<URL, Cloud> userCloudMap;
        private Target defaultTarget;

        private UserClouds(String userId) {
            this.userId = userId;
            this.userCloudMap = Collections.synchronizedMap(new HashMap());
        }

        private Cloud getCloud(URL url) {
            if ((url = URLUtil.normalizeURL(url)) == null || this.defaultTarget != null && url.equals(this.defaultTarget.getCloud().getUrl())) {
                return this.defaultTarget != null ? this.defaultTarget.getCloud() : null;
            }
            Cloud cloud = this.userCloudMap.get(url);
            if (cloud == null) {
                Cloud someCloud;
                CFExtServiceHelper helper = CFExtServiceHelper.getDefault();
                if (helper != null && helper.getService() != null && (someCloud = helper.getService().getClouds(this.userId).get(url)) != null) {
                    cloud = new DarkCloud(someCloud, this.userId);
                }
                if (cloud == null) {
                    someCloud = this.getConfigCloud();
                    cloud = someCloud != null && someCloud.getUrl().equals(url) ? someCloud : new DarkCloud(url, null, this.userId);
                }
                this.userCloudMap.put(url, cloud);
            }
            this.setAuthToken(cloud);
            return cloud;
        }

        private Cloud getConfigCloud() {
            try {
                String cloudConf = (String)OrionConfiguration.getMetaStore().readUser(this.userId).getProperties().get("cm/configurations/org.eclipse.orion.client.cf.settings");
                JSONObject cloudConfJSON = new JSONObject(cloudConf);
                URL cloudUrl = URLUtil.normalizeURL(new URL(cloudConfJSON.getString("targetUrl")));
                return new DarkCloud(cloudUrl, URLUtil.normalizeURL(new URL(cloudConfJSON.getString("manageUrl"))), this.userId);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private Target getTarget(URL url) {
            if ((url = URLUtil.normalizeURL(url)) == null) {
                return this.defaultTarget;
            }
            if (this.defaultTarget != null && url.equals(this.defaultTarget.getCloud().getUrl())) {
                return new Target(this.defaultTarget.getCloud());
            }
            Cloud cloud = this.getCloud(url);
            return new Target(cloud);
        }

        private void setDefaulTarget(Target target) {
            Cloud cloud = this.getCloud(target.getCloud().getUrl());
            Target newTarget = new Target(cloud);
            newTarget.setOrg(target.getOrg());
            newTarget.setSpace(target.getSpace());
            this.defaultTarget = newTarget;
        }

        private void setAuthToken(Cloud cloud) {
            CFExtServiceHelper helper = CFExtServiceHelper.getDefault();
            if (cloud.getAccessToken() == null && helper != null && helper.getService() != null) {
                cloud.setAccessToken(helper.getService().getToken(cloud));
            }
        }
    }
}

