/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git;

import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.orion.internal.server.core.metastore.SimpleUserPasswordUtil;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.json.JSONObject;

public class GitCredentialsProvider
extends UsernamePasswordCredentialsProvider {
    private URIish uri;
    private String remoteUser;
    private String knownHosts;
    private byte[] privateKey;
    private byte[] publicKey;
    private byte[] passphrase;

    public GitCredentialsProvider(URIish uri, String remoteUser, String username, char[] password, String knownHosts) {
        super(username, password);
        this.remoteUser = remoteUser;
        this.uri = uri;
        this.knownHosts = knownHosts;
    }

    public URIish getUri() {
        return this.uri;
    }

    public String getKnownHosts() {
        return this.knownHosts;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public byte[] getPassphrase() {
        return this.passphrase;
    }

    public void setUri(URIish uri) {
        this.uri = uri;
    }

    public void setPrivateKey(byte[] privateKey) {
        this.privateKey = privateKey;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    public void setPassphrase(byte[] passphrase) {
        this.passphrase = passphrase;
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        CredentialItem[] credentialItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            block17: {
                CredentialItem item;
                block16: {
                    item = credentialItemArray[n2];
                    if (!(!(item instanceof CredentialItem.Username) || this.privateKey != null && this.privateKey.length != 0 || this.publicKey != null && this.publicKey.length != 0 || this.passphrase != null && this.passphrase.length != 0)) {
                        CredentialItem.Username u = new CredentialItem.Username();
                        CredentialItem.Password p = new CredentialItem.Password();
                        super.get(uri, new CredentialItem[]{u, p});
                        if (!(u.getValue() != null && u.getValue().length() != 0 || p.getValue() != null && p.getValue().length != 0 || uri == null || this.remoteUser == null)) {
                            try {
                                String token;
                                block15: {
                                    UserInfo info = OrionConfiguration.getMetaStore().readUser(this.remoteUser);
                                    String property = info.getProperty("GitHubAccessToken");
                                    token = null;
                                    try {
                                        JSONObject tokens = new JSONObject(SimpleUserPasswordUtil.decryptPassword((String)property));
                                        token = tokens.optString(uri.getHost());
                                    }
                                    catch (Exception exception) {
                                        if (property == null || property.length() <= 0 || !"github.com".equals(uri.getHost())) break block15;
                                        token = property;
                                    }
                                }
                                if (token == null) break block16;
                                ((CredentialItem.Username)item).setValue(token);
                                break block17;
                            }
                            catch (CoreException coreException) {}
                        }
                    }
                }
                if (super.supports(new CredentialItem[]{item})) {
                    super.get(uri, new CredentialItem[]{item});
                } else if (item instanceof CredentialItem.StringType) {
                    if (item.getPromptText().toLowerCase(Locale.ENGLISH).contains("passphrase") && this.passphrase != null && this.passphrase.length > 0) {
                        ((CredentialItem.StringType)item).setValue(new String(this.passphrase));
                    } else {
                        ((CredentialItem.StringType)item).setValue("");
                    }
                } else if (item instanceof CredentialItem.CharArrayType) {
                    ((CredentialItem.CharArrayType)item).setValue(new char[0]);
                } else {
                    throw new UnsupportedCredentialItem(uri, item.getPromptText());
                }
            }
            ++n2;
        }
        return true;
    }
}

