/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;

public class EclipseGitProgressTransformer
implements ProgressMonitor {
    private static final String EMPTY_STRING = "";
    private final IProgressMonitor root;
    private IProgressMonitor task;
    private String msg;
    private int lastWorked;
    private int totalWork;

    public EclipseGitProgressTransformer(IProgressMonitor eclipseMonitor) {
        this.root = eclipseMonitor;
    }

    public void start(int totalTasks) {
        this.root.beginTask(EMPTY_STRING, totalTasks * 1000);
    }

    public void beginTask(String name, int total) {
        this.endTask();
        this.msg = name;
        this.lastWorked = 0;
        this.totalWork = total;
        this.task = new SubProgressMonitor(this.root, 1000);
        if (this.totalWork == 0) {
            this.task.beginTask(EMPTY_STRING, -1);
        } else {
            this.task.beginTask(EMPTY_STRING, this.totalWork);
        }
        this.task.subTask(this.msg);
    }

    public void update(int work) {
        if (this.task == null) {
            return;
        }
        int cmp = this.lastWorked + work;
        if (this.totalWork == 0 && cmp > 0) {
            if (this.lastWorked != cmp) {
                this.task.subTask(String.valueOf(this.msg) + ", " + cmp);
            }
        } else if (this.totalWork > 0 && cmp * 100 / this.totalWork != this.lastWorked * 100 / this.totalWork) {
            StringBuilder m = new StringBuilder();
            m.append(this.msg);
            m.append(": ");
            while (m.length() < 25) {
                m.append(' ');
            }
            String twstr = String.valueOf(this.totalWork);
            String cmpstr = String.valueOf(cmp);
            while (cmpstr.length() < twstr.length()) {
                cmpstr = " " + cmpstr;
            }
            int pcnt = cmp * 100 / this.totalWork;
            if (pcnt < 100) {
                m.append(' ');
            }
            if (pcnt < 10) {
                m.append(' ');
            }
            m.append(pcnt);
            m.append("% (");
            m.append(cmpstr);
            m.append("/");
            m.append(twstr);
            m.append(")");
            this.task.subTask(m.toString());
        }
        this.lastWorked = cmp;
        this.task.worked(work);
    }

    public void endTask() {
        if (this.task != null) {
            try {
                this.task.done();
            }
            finally {
                this.task = null;
            }
        }
    }

    public boolean isCancelled() {
        if (this.task != null) {
            return this.task.isCanceled();
        }
        return this.root.isCanceled();
    }
}

