/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportHttp;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.git.jobs.EclipseGitProgressTransformer;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.jobs.GitJobUtils;
import org.eclipse.orion.server.git.objects.Clone;
import org.eclipse.orion.server.git.servlets.GitCloneHandlerV1;
import org.json.JSONException;
import org.json.JSONObject;

public class CloneJob
extends GitJob {
    private final ProjectInfo project;
    private final Clone clone;
    private final String user;
    private final String gitUserName;
    private final String gitUserMail;
    private String cloneLocation;
    private final boolean initProject;

    public CloneJob(Clone clone, String userRunningTask, CredentialsProvider credentials, String user, String cloneLocation, ProjectInfo project, String gitUserName, String gitUserMail, boolean initProject) {
        super(userRunningTask, true, (GitCredentialsProvider)credentials);
        this.clone = clone;
        this.user = user;
        this.project = project;
        this.gitUserName = gitUserName;
        this.gitUserMail = gitUserMail;
        this.cloneLocation = cloneLocation;
        this.initProject = initProject;
        this.setFinalMessage("Clone complete.");
        this.setTaskExpirationTime(TimeUnit.DAYS.toMillis(7L));
    }

    public CloneJob(Clone clone, String userRunningTask, CredentialsProvider credentials, String user, String cloneLocation, ProjectInfo project, String gitUserName, String gitUserMail) {
        this(clone, userRunningTask, credentials, user, cloneLocation, project, gitUserName, gitUserMail, false);
    }

    public CloneJob(Clone clone, String userRunningTask, CredentialsProvider credentials, String user, String cloneLocation, ProjectInfo project, String gitUserName, String gitUserMail, boolean initProject, Object cookie) {
        this(clone, userRunningTask, credentials, user, cloneLocation, project, gitUserName, gitUserMail, initProject);
        this.cookie = (Cookie)cookie;
    }

    private IStatus doClone(IProgressMonitor monitor) {
        block29: {
            EclipseGitProgressTransformer gitMonitor = new EclipseGitProgressTransformer(monitor);
            Repository repo = null;
            try {
                File cloneFolder = new File(this.clone.getContentLocation().getPath());
                if (!cloneFolder.exists()) {
                    cloneFolder.mkdir();
                }
                CloneCommand cc = Git.cloneRepository();
                cc.setProgressMonitor((ProgressMonitor)gitMonitor);
                cc.setBare(false);
                cc.setCredentialsProvider((CredentialsProvider)this.credentials);
                cc.setDirectory(cloneFolder);
                cc.setRemote("origin");
                cc.setURI(this.clone.getUrl());
                cc.setCloneSubmodules(true);
                if (this.cookie != null) {
                    cc.setTransportConfigCallback(new TransportConfigCallback(){

                        public void configure(Transport t) {
                            if (t instanceof TransportHttp && CloneJob.this.cookie != null) {
                                HashMap<String, String> map = new HashMap<String, String>();
                                map.put("Cookie", String.valueOf(CloneJob.this.cookie.getName()) + "=" + CloneJob.this.cookie.getValue());
                                ((TransportHttp)t).setAdditionalHeaders(map);
                            }
                        }
                    });
                }
                Git git = cc.call();
                if (monitor.isCanceled()) {
                    Status status = new Status(8, "org.eclipse.orion.server.git", "Cancelled");
                    return status;
                }
                GitCloneHandlerV1.doConfigureClone(git, this.user, this.gitUserName, this.gitUserMail);
                repo = git.getRepository();
                GitJobUtils.packRefs(repo, gitMonitor);
                if (monitor.isCanceled()) {
                    Status status = new Status(8, "org.eclipse.orion.server.git", "Cancelled");
                    return status;
                }
                try {
                    File projectJsonFile;
                    if (!this.initProject || (projectJsonFile = new File(String.valueOf(cloneFolder.getPath()) + File.separator + "project.json")).exists()) break block29;
                    PrintStream out = null;
                    try {
                        String repoName;
                        String[] segments;
                        String serverName;
                        out = new PrintStream(new FileOutputStream(projectJsonFile));
                        JSONObject projectjson = new JSONObject();
                        String gitPath = this.clone.getUrl();
                        if (gitPath.indexOf("://") > 0) {
                            gitPath = gitPath.substring(gitPath.indexOf("://") + 3);
                        }
                        if ((serverName = (segments = gitPath.split("/"))[0]).indexOf("@") > 0) {
                            serverName = serverName.substring(serverName.indexOf("@") + 1);
                        }
                        if ((repoName = segments[segments.length - 1]).indexOf(".git") > 0) {
                            repoName = repoName.substring(0, repoName.lastIndexOf(".git"));
                        }
                        projectjson.put("Name", (Object)(String.valueOf(repoName) + " at " + serverName));
                        out.print(projectjson.toString());
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                }
                catch (IOException e) {
                    Status status = new Status(4, "org.eclipse.orion.server.git", "Error cloning git repository", (Throwable)e);
                    return status;
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    return iStatus;
                }
                catch (GitAPIException e) {
                    IStatus iStatus = this.getGitAPIExceptionStatus(e, "Error cloning git repository");
                    return iStatus;
                }
                catch (JGitInternalException e) {
                    IStatus iStatus = this.getJGitInternalExceptionStatus(e, "Error cloning git repository");
                    return iStatus;
                }
                catch (Exception e) {
                    Status status = new Status(4, "org.eclipse.orion.server.git", "Error cloning git repository", (Throwable)e);
                    return status;
                }
            }
            finally {
                if (repo != null) {
                    repo.close();
                }
            }
        }
        JSONObject jsonData = new JSONObject();
        try {
            jsonData.put("Location", (Object)URI.create(this.cloneLocation));
        }
        catch (JSONException jSONException) {}
        return new ServerStatus(Status.OK_STATUS, 200, jsonData);
    }

    protected IStatus performJob(IProgressMonitor monitor) {
        IStatus result = this.doClone(monitor);
        if (result.isOK()) {
            return result;
        }
        try {
            if (this.project != null) {
                GitCloneHandlerV1.removeProject(this.user, this.project);
            } else {
                FileUtils.delete((File)URIUtil.toFile((URI)this.clone.getContentLocation()), (int)1);
            }
        }
        catch (IOException e) {
            String msg = "An error occurred when cleaning up after a clone failure";
            LogHelper.log((IStatus)new ServerStatus(4, 500, msg, (Throwable)e));
        }
        return result;
    }
}

