/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.WorkspaceResourceHandler;
import org.eclipse.orion.server.core.IWebResourceDecorator;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.objects.Remote;
import org.eclipse.orion.server.git.objects.RemoteBranch;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitFileDecorator
implements IWebResourceDecorator {
    public void addAtributesFor(HttpServletRequest request, URI resource, JSONObject representation) {
        block17: {
            String requestPath = String.valueOf(request.getServletPath()) + (request.getPathInfo() == null ? "" : request.getPathInfo());
            Path targetPath = new Path(requestPath);
            if (targetPath.segmentCount() <= 1) {
                return;
            }
            String servlet = request.getServletPath();
            if (!"/file".equals(servlet) && !"/workspace".equals(servlet)) {
                return;
            }
            boolean isWorkspace = "/workspace".equals(servlet);
            try {
                if (isWorkspace && ServletResourceHandler.Method.POST.equals((Object)ServletResourceHandler.Method.fromString((String)request.getMethod()))) {
                    String contentLocation = representation.getString("ContentLocation");
                    this.initGitRepository(request, (IPath)targetPath, representation);
                    this.addGitLinks(request, new URI(contentLocation), representation);
                    return;
                }
                if (isWorkspace && ServletResourceHandler.Method.GET.equals((Object)ServletResourceHandler.Method.fromString((String)request.getMethod()))) {
                    JSONArray children = representation.optJSONArray("Children");
                    if (children != null) {
                        int i = 0;
                        while (i < children.length()) {
                            JSONObject child = children.getJSONObject(i);
                            String location = child.getString("Location");
                            if (location == null || location.length() == 0) {
                                String childName = child.optString("Name");
                                LogHelper.log((Throwable)new RuntimeException("Unexpected null location for child" + childName + " of resource " + resource));
                            }
                            this.addGitLinks(request, new URI(location), child);
                            ++i;
                        }
                    }
                    return;
                }
                if (isWorkspace || !ServletResourceHandler.Method.GET.equals((Object)ServletResourceHandler.Method.fromString((String)request.getMethod()))) break block17;
                Repository db = null;
                try {
                    db = this.repositoryForPath(request, (IPath)new Path(resource.getPath()));
                    URI cloneLocation = BaseToCloneConverter.getCloneLocation(resource, BaseToCloneConverter.FILE);
                    String branch = db == null ? null : db.getBranch();
                    Remote defaultRemote = db == null ? null : new Remote(cloneLocation, db, "origin");
                    RemoteBranch defaultRemoteBranch = db == null ? null : new RemoteBranch(cloneLocation, db, defaultRemote, branch);
                    this.addGitLinks(request, resource, representation, cloneLocation, db, defaultRemoteBranch, branch);
                    JSONArray children = representation.optJSONArray("Children");
                    if (children != null) {
                        int i = 0;
                        while (i < children.length()) {
                            JSONObject child = children.getJSONObject(i);
                            String location = child.getString("Location");
                            if (db != null) {
                                this.addGitLinks(request, new URI(location), child, cloneLocation, db, defaultRemoteBranch, branch);
                            } else {
                                this.addGitLinks(request, new URI(location), child);
                            }
                            ++i;
                        }
                    }
                }
                finally {
                    if (db != null) {
                        db.close();
                    }
                }
            }
            catch (Exception e) {
                LogHelper.log((Throwable)e);
            }
        }
    }

    private void addGitLinks(HttpServletRequest request, URI location, JSONObject representation) throws URISyntaxException, JSONException, CoreException, IOException {
        Repository db = null;
        try {
            db = this.repositoryForPath(request, (IPath)new Path(location.getPath()));
            if (db != null) {
                URI cloneLocation = BaseToCloneConverter.getCloneLocation(location, BaseToCloneConverter.FILE);
                String branch = db.getBranch();
                Remote defaultRemote = new Remote(cloneLocation, db, "origin");
                RemoteBranch defaultRemoteBranch = new RemoteBranch(cloneLocation, db, defaultRemote, branch);
                this.addGitLinks(request, location, representation, cloneLocation, db, defaultRemoteBranch, branch);
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    private void addGitLinks(HttpServletRequest request, URI location, JSONObject representation, URI cloneLocation, Repository db, RemoteBranch defaultRemoteBranch, String branchName) throws URISyntaxException, JSONException {
        if (db == null) {
            return;
        }
        Path targetPath = new Path(location.getPath());
        JSONObject gitSection = new JSONObject();
        IPath path = new Path("/gitapi/diff/Default").append((IPath)targetPath);
        URI link = new URI(location.getScheme(), location.getAuthority(), path.toString(), null, null);
        gitSection.put("DiffLocation", (Object)link);
        path = new Path("/gitapi/status").append((IPath)targetPath);
        link = new URI(location.getScheme(), location.getAuthority(), path.toString(), null, null);
        gitSection.put("StatusLocation", (Object)link);
        path = new Path("/gitapi/index").append((IPath)targetPath);
        link = new URI(location.getScheme(), location.getAuthority(), path.toString(), null, null);
        gitSection.put("IndexLocation", (Object)link);
        path = new Path("/gitapi/ignore").append((IPath)targetPath);
        link = new URI(location.getScheme(), location.getAuthority(), path.toString(), null, null);
        gitSection.put("IgnoreLocation", (Object)link);
        path = new Path("/gitapi/commit").append("HEAD").append((IPath)targetPath);
        link = new URI(location.getScheme(), location.getAuthority(), path.toString(), null, null);
        gitSection.put("HeadLocation", (Object)link);
        path = new Path("/gitapi/commit").append(GitUtils.encode(branchName)).append((IPath)targetPath);
        link = new URI(location.getScheme(), location.getAuthority(), path.toString(), null, null);
        gitSection.put("CommitLocation", (Object)link);
        path = new Path("/gitapi/remote").append((IPath)targetPath);
        link = new URI(location.getScheme(), location.getAuthority(), path.toString(), null, null);
        gitSection.put("RemoteLocation", (Object)link);
        path = new Path("/gitapi/config/clone").append((IPath)targetPath);
        link = new URI(location.getScheme(), location.getAuthority(), path.toString(), null, null);
        gitSection.put("ConfigLocation", (Object)link);
        gitSection.put("DefaultRemoteBranchLocation", (Object)defaultRemoteBranch.getLocation());
        path = new Path("/gitapi/tag").append((IPath)targetPath);
        link = new URI(location.getScheme(), location.getAuthority(), path.toString(), null, null);
        gitSection.put("TagLocation", (Object)link);
        path = new Path("/gitapi/blame").append("HEAD").append((IPath)targetPath);
        link = new URI(location.getScheme(), location.getAuthority(), path.toString(), null, null);
        gitSection.put("BlameLocation", (Object)link);
        gitSection.put("CloneLocation", (Object)cloneLocation);
        IPath clonePath = new Path(cloneLocation.getPath()).removeFirstSegments(2);
        int suffixLength = Math.min(targetPath.toPortableString().length(), clonePath.toPortableString().length());
        path = new Path("/gitapi/tree").append(clonePath).append("HEAD").append(targetPath.toPortableString().substring(suffixLength));
        link = new URI(location.getScheme(), location.getAuthority(), path.toString(), null, null);
        gitSection.put("TreeLocation", (Object)link);
        representation.put("Git", (Object)gitSection);
    }

    private Repository repositoryForPath(HttpServletRequest request, IPath targetPath) throws CoreException, IOException {
        File gitDir;
        Path contextPath;
        IPath requestPath = targetPath;
        if (request.getContextPath().length() != 0 && (contextPath = new Path(request.getContextPath())).isPrefixOf(targetPath)) {
            requestPath = targetPath.removeFirstSegments(contextPath.segmentCount());
        }
        if ((gitDir = GitUtils.getGitDir(requestPath)) == null) {
            return null;
        }
        Repository db = FileRepositoryBuilder.create((File)gitDir);
        return db;
    }

    private void initGitRepository(HttpServletRequest request, IPath targetPath, JSONObject representation) {
        block9: {
            if (targetPath.segmentCount() != 2 || !"workspace".equals(targetPath.segment(0)) || !ServletResourceHandler.Method.POST.equals((Object)ServletResourceHandler.Method.fromString((String)request.getMethod()))) {
                return;
            }
            String scm = PreferenceHelper.getString((String)"orion.file.defaultSCM", (String)"").toLowerCase();
            if (!"git".equals(scm)) {
                return;
            }
            try {
                ProjectInfo project = this.getProjectForLocation(representation.getString("Location"));
                if (project == null) {
                    return;
                }
                IFileStore store = project.getProjectStore();
                File localFile = store.toLocalFile(0, null);
                File gitDir = GitUtils.getGitDir(localFile);
                if (gitDir != null) break block9;
                gitDir = new File(localFile, ".git");
                Repository repo = null;
                try {
                    repo = FileRepositoryBuilder.create((File)gitDir);
                    repo.create();
                    Git git = new Git(repo);
                    git.add().addFilepattern(".").call();
                    git.commit().setMessage("Initial commit").call();
                }
                finally {
                    if (repo != null) {
                        repo.close();
                    }
                }
            }
            catch (Exception e) {
                LogHelper.log((Throwable)e);
            }
        }
    }

    private ProjectInfo getProjectForLocation(String location) throws CoreException {
        IMetaStore store = OrionConfiguration.getMetaStore();
        return WorkspaceResourceHandler.projectForMetadataLocation((IMetaStore)store, (String)location);
    }
}

