/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;

public class ObjectIdSubclassMap<V extends ObjectId>
implements Iterable<V> {
    private static final int INITIAL_TABLE_SIZE = 2048;
    private int size;
    private int grow;
    private int mask;
    private V[] table;

    public ObjectIdSubclassMap() {
        this.initTable(2048);
    }

    public void clear() {
        this.size = 0;
        this.initTable(2048);
    }

    public V get(AnyObjectId toFind) {
        V obj;
        int msk = this.mask;
        int i = toFind.w1 & msk;
        V[] tbl = this.table;
        while ((obj = tbl[i]) != null) {
            if (AnyObjectId.equals(obj, toFind)) {
                return obj;
            }
            i = i + 1 & msk;
        }
        return null;
    }

    public boolean contains(AnyObjectId toFind) {
        return this.get(toFind) != null;
    }

    public <Q extends V> void add(Q newValue) {
        if (++this.size == this.grow) {
            this.grow();
        }
        this.insert(newValue);
    }

    public <Q extends V> V addIfAbsent(Q newValue) {
        V obj;
        int msk = this.mask;
        int i = ((ObjectId)newValue).w1 & msk;
        V[] tbl = this.table;
        while ((obj = tbl[i]) != null) {
            if (AnyObjectId.equals(obj, newValue)) {
                return obj;
            }
            i = i + 1 & msk;
        }
        if (++this.size == this.grow) {
            this.grow();
            this.insert(newValue);
        } else {
            tbl[i] = newValue;
        }
        return newValue;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            private int found;
            private int i;

            @Override
            public boolean hasNext() {
                return this.found < ObjectIdSubclassMap.this.size;
            }

            @Override
            public V next() {
                while (this.i < ObjectIdSubclassMap.this.table.length) {
                    ObjectId v = ObjectIdSubclassMap.this.table[this.i++];
                    if (v == null) continue;
                    ++this.found;
                    return v;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void insert(V newValue) {
        int msk = this.mask;
        int j = ((ObjectId)newValue).w1 & msk;
        V[] tbl = this.table;
        while (tbl[j] != null) {
            j = j + 1 & msk;
        }
        tbl[j] = newValue;
    }

    private void grow() {
        V[] oldTable = this.table;
        int oldSize = this.table.length;
        this.initTable(oldSize << 1);
        for (int i = 0; i < oldSize; ++i) {
            V obj = oldTable[i];
            if (obj == null) continue;
            this.insert(obj);
        }
    }

    private void initTable(int sz) {
        this.grow = sz >> 1;
        this.mask = sz - 1;
        this.table = this.createArray(sz);
    }

    private final V[] createArray(int sz) {
        return new ObjectId[sz];
    }
}

