/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.cf.commands.ICFCommand;
import org.eclipse.orion.server.cf.manifest.v2.AnalyzerException;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.manifest.v2.ParserException;
import org.eclipse.orion.server.cf.manifest.v2.TokenizerException;
import org.eclipse.orion.server.cf.manifest.v2.utils.ManifestUtils;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseManifestJSONCommand
implements ICFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private JSONObject manifestJSON;
    private ManifestParseTree manifest;
    private IFileStore appStore;
    private String contentLocation;
    private String commandName;
    private String userId;
    private IFileStore persistBaseLocation;

    public IFileStore getPersistBaseLocation() {
        return this.persistBaseLocation;
    }

    public ManifestParseTree getManifest() {
        return this.manifest;
    }

    public IFileStore getAppStore() {
        return this.appStore;
    }

    public ParseManifestJSONCommand(JSONObject manifestJSON, String userId, String contentLocation) {
        this.manifestJSON = manifestJSON;
        this.userId = userId;
        this.contentLocation = contentLocation;
        this.commandName = "Parse manifest JSON representation";
    }

    private ServerStatus canAccess(IPath contentPath) throws CoreException {
        String accessLocation = "/file/" + contentPath.toString();
        if (contentPath.segmentCount() < 1) {
            return new ServerStatus(4, 403, "Forbidden access to application contents", null);
        }
        if (!AuthorizationService.checkRights((String)this.userId, (String)accessLocation, (String)"GET")) {
            return new ServerStatus(4, 403, "Forbidden access to application contents", null);
        }
        return new ServerStatus(Status.OK_STATUS, 200);
    }

    @Override
    public IStatus doIt() {
        if (this.manifestJSON == null) {
            return new ServerStatus(4, 400, "Missing manifest JSON representation", null);
        }
        try {
            IPath appStorePath;
            String path;
            IPath contentPath = new Path(this.contentLocation).removeFirstSegments(1);
            ServerStatus accessStatus = this.canAccess(contentPath);
            if (!accessStatus.isOK()) {
                return accessStatus;
            }
            IFileStore fileStore = NewFileServlet.getFileStore(null, (IPath)contentPath);
            if (!fileStore.fetchInfo().isDirectory()) {
                fileStore = fileStore.getParent();
                contentPath = contentPath.removeLastSegments(1);
            }
            this.manifest = ManifestUtils.parse(this.manifestJSON);
            ManifestParseTree app = this.manifest.get("applications").get(0);
            ManifestParseTree pathNode = app.getOpt("path");
            String string = path = pathNode != null ? pathNode.getValue() : "";
            if (path.isEmpty()) {
                path = ".";
            }
            if (!(accessStatus = this.canAccess(appStorePath = contentPath.append(path))).isOK()) {
                return accessStatus;
            }
            this.appStore = NewFileServlet.getFileStore(null, (IPath)appStorePath);
            if (this.appStore == null) {
                String msg = NLS.bind((String)"Failed to find application content due to incorrect path parameter: {0}", (Object)appStorePath);
                return new ServerStatus(4, 400, msg, null);
            }
            this.persistBaseLocation = this.appStore.fetchInfo().isDirectory() ? this.appStore : fileStore;
            return new ServerStatus(Status.OK_STATUS, 200);
        }
        catch (IllegalArgumentException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
        catch (TokenizerException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
        catch (ParserException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
        catch (AnalyzerException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
        catch (InvalidAccessException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

