/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.manifest.v2.Analyzer;
import org.eclipse.orion.server.cf.manifest.v2.AnalyzerException;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.manifest.v2.ParserException;
import org.eclipse.orion.server.cf.manifest.v2.TokenizerException;
import org.eclipse.orion.server.cf.manifest.v2.utils.ManifestUtils;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseManifestCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String userId;
    private String contentLocation;
    private String commandName;
    private ManifestParseTree manifest;
    private IFileStore appStore;
    private IFileStore manifestStore;
    private Analyzer applicationAnalyzer;
    private boolean strict;

    public ParseManifestCommand(Target target, String userId, String contentLocation) {
        super(target);
        this.userId = userId;
        this.contentLocation = contentLocation;
        this.applicationAnalyzer = null;
        this.strict = false;
        this.commandName = NLS.bind((String)"Parse application manifest: {0}", (Object)contentLocation);
    }

    public void setStrict(boolean force) {
        this.strict = force;
    }

    public void setApplicationAnalyzer(Analyzer applicationAnalyzer) {
        this.applicationAnalyzer = applicationAnalyzer;
    }

    public ManifestParseTree getManifest() {
        return this.manifest;
    }

    public IFileStore getAppStore() {
        return this.appStore;
    }

    public IFileStore getManifestStore() {
        return this.manifestStore;
    }

    private ServerStatus canAccess(IPath contentPath) throws CoreException {
        String accessLocation = "/file/" + contentPath.toString();
        if (contentPath.segmentCount() < 1) {
            return new ServerStatus(4, 403, "Forbidden access to application contents", null);
        }
        if (!AuthorizationService.checkRights((String)this.userId, (String)accessLocation, (String)"GET")) {
            return new ServerStatus(4, 403, "Forbidden access to application contents", null);
        }
        return new ServerStatus(Status.OK_STATUS, 200);
    }

    private ServerStatus cannotFindManifest(IPath contentPath) {
        IPath manifestPath = contentPath.removeFirstSegments(2).append("manifest.yml");
        String msg = "Failed to find /" + manifestPath + ". If the manifest is in a different folder, please select the manifest file or folder before deploying.";
        return new ServerStatus(4, 404, msg, null);
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            ManifestParseTree app;
            ManifestParseTree pathNode;
            String path;
            IPath contentPath = new Path(this.contentLocation).removeFirstSegments(1);
            ServerStatus accessStatus = this.canAccess(contentPath);
            if (!accessStatus.isOK()) {
                return accessStatus;
            }
            IFileStore fileStore = NewFileServlet.getFileStore(null, (IPath)contentPath);
            if (!fileStore.fetchInfo().isDirectory() && !this.strict) {
                fileStore = fileStore.getParent();
                contentPath = contentPath.removeLastSegments(1);
            }
            if (fileStore == null) {
                return this.cannotFindManifest(contentPath);
            }
            IFileStore iFileStore = this.manifestStore = this.strict ? fileStore : fileStore.getChild("manifest.yml");
            if (!this.manifestStore.fetchInfo().exists()) {
                return this.cannotFindManifest(contentPath);
            }
            ProjectInfo project = OrionConfiguration.getMetaStore().readProject(contentPath.segment(0), contentPath.segment(1));
            IFileStore projectStore = NewFileServlet.getFileStore(null, (ProjectInfo)project);
            ManifestParseTree manifest = null;
            String targetBase = null;
            if (this.target != null) {
                URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
                targetBase = targetURI.getHost().substring(4);
            }
            String string = path = (pathNode = (app = (manifest = ManifestUtils.parse(projectStore, this.manifestStore, targetBase, this.applicationAnalyzer)).get("applications").get(0)).getOpt("path")) != null ? pathNode.getValue() : "";
            if (path.isEmpty()) {
                path = ".";
            }
            try {
                IPath appStorePath = contentPath.append(path);
                accessStatus = this.canAccess(appStorePath);
                if (!accessStatus.isOK()) {
                    return accessStatus;
                }
                this.appStore = NewFileServlet.getFileStore(null, (IPath)appStorePath);
                if (this.appStore == null) {
                    String msg = NLS.bind((String)"Failed to find application content due to incorrect path parameter: {0}", (Object)appStorePath);
                    return new ServerStatus(4, 400, msg, null);
                }
                this.manifest = manifest;
            }
            catch (Exception exception) {
                return new ServerStatus(4, 400, "Failed to locate application contents as specified in the manifest.", null);
            }
            return new ServerStatus(Status.OK_STATUS, 200);
        }
        catch (TokenizerException e) {
            return new ServerStatus(4, 400, e.getMessage(), e.getDetails(), null);
        }
        catch (ParserException e) {
            return new ServerStatus(4, 400, e.getMessage(), e.getDetails(), null);
        }
        catch (AnalyzerException e) {
            return new ServerStatus(4, 400, e.getMessage(), e.getDetails(), null);
        }
        catch (InvalidAccessException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
        catch (IOException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

