/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.manifest.v2;

import java.io.Closeable;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.Token;
import org.eclipse.orion.server.core.IOUtilities;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ManifestParseTree {
    private static final Pattern memoryPattern = Pattern.compile("[1-9][0-9]*(M|MB|G|GB|m|mb|g|gb)");
    private static final Pattern nonNegativePattern = Pattern.compile("[1-9][0-9]*");
    private List<Token> tokens;
    private List<ManifestParseTree> children;
    private ManifestParseTree parent;
    private int level;

    public ManifestParseTree() {
        this.children = new ArrayList<ManifestParseTree>();
        this.tokens = new ArrayList<Token>();
        this.parent = this;
        this.level = 0;
    }

    public ManifestParseTree(int level) {
        this.children = new ArrayList<ManifestParseTree>();
        this.tokens = new ArrayList<Token>();
        this.parent = this;
        this.level = level;
    }

    public ManifestParseTree(ManifestParseTree node) {
        this.level = node.getLevel();
        this.setParent(this);
        this.tokens = new ArrayList<Token>();
        for (Token token : node.getTokens()) {
            Token newToken = new Token(token.getContent(), token.getType());
            newToken.setIndentation(token.getIndentation());
            newToken.setLineNumber(token.getLineNumber());
            this.tokens.add(newToken);
        }
        this.children = new ArrayList<ManifestParseTree>();
        for (ManifestParseTree child : node.getChildren()) {
            ManifestParseTree newChild = new ManifestParseTree(child);
            newChild.setParent(this);
            this.children.add(newChild);
        }
    }

    public void put(String key, String value) {
        if (this.has(key)) {
            try {
                ManifestParseTree keyNode = this.get(key);
                keyNode.update(value);
                return;
            }
            catch (InvalidAccessException invalidAccessException) {}
        }
        ManifestParseTree keyNode = new ManifestParseTree(this.getLevel());
        Token keyToken = new Token(key, 4);
        keyNode.getTokens().add(keyToken);
        ManifestParseTree valueNode = new ManifestParseTree(this.getLevel());
        keyNode.getChildren().add(valueNode);
        valueNode.setParent(keyNode);
        Token valueToken = new Token(value, 4);
        valueNode.getTokens().add(valueToken);
        this.getChildren().add(keyNode);
        keyNode.setParent(this);
    }

    public void put(String key, JSONObject object) throws JSONException {
        if (this.has(key)) {
            try {
                ManifestParseTree keyNode = this.get(key);
                String[] stringArray = JSONObject.getNames((JSONObject)object);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String k = stringArray[n2];
                    String v = object.getString(k);
                    keyNode.put(k, v);
                    ++n2;
                }
                return;
            }
            catch (InvalidAccessException invalidAccessException) {}
        }
        ManifestParseTree keyNode = new ManifestParseTree(this.getLevel());
        Token keyToken = new Token(key, 4);
        keyNode.getTokens().add(keyToken);
        String[] stringArray = JSONObject.getNames((JSONObject)object);
        int n = stringArray.length;
        int n3 = 0;
        while (n3 < n) {
            String k = stringArray[n3];
            String v = object.getString(k);
            keyNode.put(k, v);
            ++n3;
        }
        this.getChildren().add(keyNode);
        keyNode.setParent(this);
    }

    public void update(String value) {
        if (this.getChildren().isEmpty()) {
            return;
        }
        ManifestParseTree child = this.getChildren().get(0);
        child.getTokens().clear();
        child.getTokens().add(new Token(value, 4));
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        int n = this.tokens.size();
        int i = 0;
        while (i < n) {
            Token token = this.tokens.get(i);
            sb.append(token.getContent());
            if (3 != token.getType() && i + 1 < n && 3 != this.tokens.get(i + 1).getType()) {
                sb.append(" ");
            }
            ++i;
        }
        return sb.toString().trim();
    }

    public ManifestParseTree get(String childName) throws InvalidAccessException {
        for (ManifestParseTree child : this.children) {
            if (!childName.equals(child.getLabel())) continue;
            return child;
        }
        throw new InvalidAccessException(this, childName);
    }

    public ManifestParseTree getOpt(String childName) {
        for (ManifestParseTree child : this.children) {
            if (!childName.equals(child.getLabel())) continue;
            return child;
        }
        return null;
    }

    public boolean has(String childName) {
        return this.getOpt(childName) != null;
    }

    public ManifestParseTree get(int kthChild) throws InvalidAccessException {
        int curretChild = -1;
        for (ManifestParseTree child : this.children) {
            if (!child.isItemNode() || ++curretChild != kthChild) continue;
            return child;
        }
        throw new InvalidAccessException(this, kthChild);
    }

    public String getValue() throws InvalidAccessException {
        if (this.children.isEmpty()) {
            throw new InvalidAccessException(this);
        }
        return this.children.get(0).getLabel().replaceAll("^\"|^'|\"$|'$", "");
    }

    public boolean isList() {
        if (this.children.isEmpty()) {
            return false;
        }
        return this.children.get(0).isItemNode();
    }

    public boolean isStringProperty() {
        if (this.getChildren().size() != 1) {
            return false;
        }
        if (this.isList()) {
            return false;
        }
        ManifestParseTree valueNode = this.getChildren().get(0);
        return valueNode.getChildren().size() == 0;
    }

    public boolean isValidMemoryProperty() {
        if (!this.isStringProperty()) {
            return false;
        }
        try {
            String memoryValue = this.getValue();
            Matcher matcher = memoryPattern.matcher(memoryValue);
            return matcher.matches();
        }
        catch (InvalidAccessException invalidAccessException) {
            return false;
        }
    }

    public boolean isValidNonNegativeProperty() {
        if (!this.isStringProperty()) {
            return false;
        }
        try {
            String instancesValue = this.getValue();
            Matcher matcher = nonNegativePattern.matcher(instancesValue);
            return matcher.matches();
        }
        catch (InvalidAccessException invalidAccessException) {
            return false;
        }
    }

    protected String toString(int indentation) {
        StringBuilder sb = new StringBuilder();
        if (this.getParent() == this) {
            sb.append("---").append(System.getProperty("line.separator"));
            for (ManifestParseTree child : this.children) {
                sb.append(child.toString(0)).append(System.getProperty("line.separator"));
            }
            return sb.toString();
        }
        int i = 0;
        while (i < indentation) {
            sb.append(" ");
            ++i;
        }
        sb.append(this.getLabel());
        boolean isItemNode = this.isItemNode();
        if (!isItemNode && this.children.size() > 0) {
            sb.append(":");
        }
        int childrenSize = this.children.size();
        int i2 = 0;
        while (i2 < childrenSize) {
            ManifestParseTree child = this.children.get(i2);
            if (isItemNode && i2 == 0 || childrenSize == 1 && child.getChildren().size() == 0) {
                sb.append(" ");
                sb.append(child.toString(0));
            } else {
                sb.append(System.getProperty("line.separator"));
                if (!child.isItemNode() || this.getParent().isItemNode()) {
                    sb.append(child.toString(indentation + 2));
                } else {
                    sb.append(child.toString(indentation));
                }
            }
            ++i2;
        }
        return sb.toString();
    }

    public JSONObject toJSON() throws JSONException, InvalidAccessException {
        JSONObject rep = new JSONObject();
        for (ManifestParseTree child : this.getChildren()) {
            child.append(rep);
        }
        return rep;
    }

    protected void append(JSONObject rep) throws JSONException, InvalidAccessException {
        if (this.isList()) {
            JSONArray arr = new JSONArray();
            for (ManifestParseTree child : this.getChildren()) {
                child.append(arr);
            }
            rep.put(this.getLabel(), (Object)arr);
            return;
        }
        if (this.getChildren().size() == 1 && this.getChildren().get(0).getChildren().size() == 0) {
            rep.put(this.getLabel(), (Object)this.getValue());
            return;
        }
        JSONObject obj = new JSONObject();
        for (ManifestParseTree child : this.getChildren()) {
            child.append(obj);
        }
        rep.put(this.getLabel(), (Object)obj);
    }

    protected void append(JSONArray rep) throws JSONException, InvalidAccessException {
        if (this.getChildren().size() == 1 && this.getChildren().get(0).getChildren().size() == 0) {
            rep.put((Object)this.getChildren().get(0).getLabel());
            return;
        }
        JSONObject obj = new JSONObject();
        for (ManifestParseTree child : this.getChildren()) {
            child.append(obj);
        }
        rep.put((Object)obj);
    }

    public void persist(IFileStore fileStore) throws CoreException {
        PrintStream ps = null;
        try {
            String representation = this.toString();
            OutputStream out = fileStore.openOutputStream(2, null);
            ps = new PrintStream(out);
            ps.print(representation);
        }
        catch (Throwable throwable) {
            if (ps != null) {
                IOUtilities.safeClose(ps);
            }
            throw throwable;
        }
        if (ps != null) {
            IOUtilities.safeClose((Closeable)ps);
        }
    }

    public boolean isRoot() {
        return this.parent == this;
    }

    public boolean isItemNode() {
        return this.tokens.size() == 1 && 2 == this.tokens.get(0).getType();
    }

    public List<ManifestParseTree> getChildren() {
        return this.children;
    }

    public ManifestParseTree getParent() {
        return this.parent;
    }

    public void setParent(ManifestParseTree father) {
        this.parent = father;
    }

    public int getLevel() {
        return this.level;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ManifestParseTree)) {
            return false;
        }
        ManifestParseTree tree = (ManifestParseTree)obj;
        return this.getLabel().equals(tree.getLabel());
    }

    public int hashCode() {
        return this.getLabel().hashCode();
    }
}

