/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.orion.internal.server.servlets.ChangeEvent;
import org.eclipse.orion.internal.server.servlets.IFileStoreModificationListener;
import org.eclipse.orion.internal.server.servlets.file.FilesystemModificationListenerManager;

public class FileStoreNotificationWrapper
implements IFileStore {
    private final Object source;
    private final IFileStore wrapped;

    private void notifyOfWrite(ChangeEvent event) {
        FilesystemModificationListenerManager.getInstance().notifyOfChange(event);
    }

    public static FileStoreNotificationWrapper wrap(Object source, IFileStore store) {
        if (store == null) {
            return null;
        }
        return new FileStoreNotificationWrapper(source, store);
    }

    private FileStoreNotificationWrapper(Object source, IFileStore store) {
        this.source = source;
        this.wrapped = store;
    }

    public Object getAdapter(Class adapter) {
        return this.wrapped.getAdapter(adapter);
    }

    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        return this.wrapped.childInfos(options, monitor);
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        return this.wrapped.childNames(options, monitor);
    }

    public IFileStore[] childStores(int options, IProgressMonitor monitor) throws CoreException {
        IFileStore[] toWrap = this.wrapped.childStores(options, monitor);
        int i = 0;
        while (i < toWrap.length) {
            toWrap[i] = FileStoreNotificationWrapper.wrap(this.source, toWrap[i]);
            ++i;
        }
        return toWrap;
    }

    public void copy(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        destination = FileStoreNotificationWrapper.unwrap(destination);
        this.wrapped.copy(destination, options, monitor);
        this.notifyOfWrite(new ChangeEvent(this.source, IFileStoreModificationListener.ChangeType.COPY_INTO, destination, this.wrapped));
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        this.wrapped.delete(options, monitor);
        this.notifyOfWrite(new ChangeEvent(this.source, IFileStoreModificationListener.ChangeType.DELETE, this.wrapped));
    }

    public IFileInfo fetchInfo() {
        return this.wrapped.fetchInfo();
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        return this.wrapped.fetchInfo(options, monitor);
    }

    public IFileStore getChild(IPath path) {
        return FileStoreNotificationWrapper.wrap(this.source, this.wrapped.getChild(path));
    }

    public IFileStore getFileStore(IPath path) {
        return FileStoreNotificationWrapper.wrap(this.source, this.wrapped.getFileStore(path));
    }

    public IFileStore getChild(String name) {
        return FileStoreNotificationWrapper.wrap(this.source, this.wrapped.getChild(name));
    }

    public IFileSystem getFileSystem() {
        return this.wrapped.getFileSystem();
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public IFileStore getParent() {
        return FileStoreNotificationWrapper.wrap(this.source, this.wrapped.getParent());
    }

    public boolean isParentOf(IFileStore other) {
        other = FileStoreNotificationWrapper.unwrap(other);
        return this.wrapped.isParentOf(other);
    }

    public static IFileStore unwrap(IFileStore other) {
        if (other instanceof FileStoreNotificationWrapper) {
            other = ((FileStoreNotificationWrapper)other).wrapped;
        }
        return other;
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        IFileStore mkdir = this.wrapped.mkdir(options, monitor);
        this.notifyOfWrite(new ChangeEvent(this.source, IFileStoreModificationListener.ChangeType.MKDIR, mkdir));
        return FileStoreNotificationWrapper.wrap(this.source, mkdir);
    }

    public void move(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        destination = FileStoreNotificationWrapper.unwrap(destination);
        this.wrapped.move(destination, options, monitor);
        this.notifyOfWrite(new ChangeEvent(this.source, IFileStoreModificationListener.ChangeType.MOVE, destination, this.wrapped));
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        return this.wrapped.openInputStream(options, monitor);
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        final OutputStream out = this.wrapped.openOutputStream(options, monitor);
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                out.write(b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                out.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                out.write(b, off, len);
            }

            @Override
            public void flush() throws IOException {
                out.flush();
            }

            @Override
            public void close() throws IOException {
                try {
                    out.close();
                }
                finally {
                    FileStoreNotificationWrapper.this.notifyOfWrite(new ChangeEvent(FileStoreNotificationWrapper.this.source, IFileStoreModificationListener.ChangeType.WRITE, FileStoreNotificationWrapper.this.wrapped));
                }
            }
        };
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        this.wrapped.putInfo(info, options, monitor);
        this.notifyOfWrite(new ChangeEvent(this.source, IFileStoreModificationListener.ChangeType.PUTINFO, this.wrapped));
    }

    public File toLocalFile(int options, IProgressMonitor monitor) throws CoreException {
        return this.wrapped.toLocalFile(options, monitor);
    }

    public URI toURI() {
        return this.wrapped.toURI();
    }

    public boolean equals(Object o) {
        return o instanceof FileStoreNotificationWrapper && this.wrapped.equals(FileStoreNotificationWrapper.unwrap((FileStoreNotificationWrapper)o));
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }
}

