/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.objc_super;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableItem
extends Item {
    Table parent;
    String[] strings;
    Image[] images;
    boolean checked;
    boolean grayed;
    boolean cached;
    Color foreground;
    Color background;
    Color[] cellForeground;
    Color[] cellBackground;
    Font font;
    Font[] cellFont;
    int width = -1;

    public TableItem(Table parent, int style) {
        this(parent, style, TableItem.checkNull(parent).getItemCount(), true);
    }

    public TableItem(Table parent, int style, int index) {
        this(parent, style, index, true);
    }

    TableItem(Table parent, int style, int index, boolean create) {
        super(parent, style);
        this.parent = parent;
        if (create) {
            parent.createItem(this, index);
        }
    }

    static Table checkNull(Table control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    int calculateWidth(int index, GC gc, boolean rowSelected) {
        String text;
        if (index == 0 && this.width != -1) {
            return this.width;
        }
        Font font = null;
        if (this.cellFont != null) {
            font = this.cellFont[index];
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.parent.font;
        }
        if (font == null) {
            font = this.parent.defaultFont();
        }
        String string = index == 0 ? this.text : (text = this.strings == null ? "" : this.strings[index]);
        Image image = index == 0 ? this.image : (this.images == null ? null : this.images[index]);
        NSTextFieldCell cell = this.parent.dataCell;
        if (font.extraTraits != 0) {
            NSAttributedString attribStr = this.parent.createString(text, font, null, 0, false, true, false);
            cell.setAttributedStringValue(attribStr);
            attribStr.release();
        } else {
            cell.setFont(font.handle);
            NSString str = (NSString)new NSString().alloc();
            str = str.initWithString(text != null ? text : "");
            cell.setTitle(str);
            str.release();
        }
        objc_super super_struct = new objc_super();
        super_struct.receiver = cell.id;
        super_struct.super_class = OS.objc_msgSend(cell.id, OS.sel_superclass);
        NSSize size = new NSSize();
        OS.objc_msgSendSuper_stret(size, super_struct, OS.sel_cellSize);
        if (image != null) {
            size.width += (float)(this.parent.imageBounds.width + 3);
        }
        int width = (int)Math.ceil(size.width);
        boolean sendMeasure = true;
        if ((this.parent.style & 0x10000000) != 0) {
            sendMeasure = this.cached;
        }
        if (sendMeasure && this.parent.hooks(41)) {
            gc.setFont(font);
            Event event = new Event();
            event.item = this;
            event.index = index;
            event.gc = gc;
            NSTableView widget = (NSTableView)this.parent.view;
            int height = (int)widget.rowHeight();
            event.width = width;
            event.height = height;
            if (rowSelected && ((this.parent.style & 0x8000) == 0 || this.parent.hasFocus())) {
                event.detail |= 2;
            }
            this.parent.sendEvent(41, event);
            if (height < event.height) {
                widget.setRowHeight(event.height);
                widget.setNeedsDisplay(true);
            }
            width = event.width;
        }
        if (index == 0) {
            this.width = width;
        }
        return width;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.text = "";
        this.image = null;
        this.strings = null;
        this.images = null;
        this.cached = false;
        this.grayed = false;
        this.checked = false;
        this.background = null;
        this.foreground = null;
        this.cellBackground = null;
        this.cellForeground = null;
        this.font = null;
        this.cellFont = null;
        this.width = -1;
    }

    NSObject createString(int index) {
        String text = index == 0 ? this.text : (this.strings == null ? "" : this.strings[index]);
        return NSString.stringWith(text != null ? text : "");
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.background != null ? this.background : this.parent.getBackground();
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getBackground();
        }
        if (this.cellBackground == null || this.cellBackground[index] == null) {
            return this.getBackground();
        }
        return this.cellBackground[index];
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        NSTableView widget = (NSTableView)this.parent.view;
        int rowIndex = this.parent.indexOf(this);
        NSTableColumn column = this.parent.columnCount == 0 ? this.parent.firstColumn : this.parent.columns[0].nsColumn;
        int columnIndex = this.parent.indexOf(column);
        NSRect titleRect = widget.frameOfCellAtColumn(columnIndex, rowIndex);
        if (this.image != null) {
            titleRect.x += (float)(this.parent.imageBounds.width + 3);
        }
        Font font = null;
        if (this.cellFont != null) {
            font = this.cellFont[columnIndex];
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.parent.font;
        }
        if (font == null) {
            font = this.parent.defaultFont();
        }
        NSTextFieldCell cell = this.parent.dataCell;
        cell.setImage(null);
        if (font.extraTraits != 0) {
            NSAttributedString attribStr = this.parent.createString(this.text, font, null, 0, false, true, false);
            cell.setAttributedStringValue(attribStr);
            attribStr.release();
        } else {
            cell.setFont(font.handle);
            NSString str = (NSString)new NSString().alloc();
            str = str.initWithString(this.text);
            cell.setTitle(str);
            str.release();
        }
        objc_super super_struct = new objc_super();
        super_struct.receiver = cell.id;
        super_struct.super_class = OS.objc_msgSend(cell.id, OS.sel_superclass);
        NSSize size = new NSSize();
        OS.objc_msgSendSuper_stret(size, super_struct, OS.sel_cellSize);
        NSRect columnRect = widget.rectOfColumn(columnIndex);
        size.width = Math.min(size.width, columnRect.width - (titleRect.x - columnRect.x));
        return new Rectangle((int)titleRect.x, (int)titleRect.y, (int)Math.ceil(size.width), (int)Math.ceil(titleRect.height));
    }

    public Rectangle getBounds(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index < 0 || index >= Math.max(1, this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        NSTableView tableView = (NSTableView)this.parent.view;
        if (this.parent.columnCount == 0) {
            index = (this.parent.style & 0x20) != 0 ? 1 : 0;
        } else {
            TableColumn column = this.parent.getColumn(index);
            index = this.parent.indexOf(column.nsColumn);
        }
        NSRect rect = tableView.frameOfCellAtColumn(index, this.parent.indexOf(this));
        return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.checked;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[index] == null) {
            return this.getFont();
        }
        return this.cellFont[index];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.foreground != null ? this.foreground : this.parent.getForeground();
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getForeground();
        }
        if (this.cellForeground == null || this.cellForeground[index] == null) {
            return this.getForeground();
        }
        return this.cellForeground[index];
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index == 0) {
            return this.getImage();
        }
        if (this.images != null && index >= 0 && index < this.images.length) {
            return this.images[index];
        }
        return null;
    }

    public Rectangle getImageBounds(int index) {
        Image image;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index < 0 || index >= Math.max(1, this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        NSTableView tableView = (NSTableView)this.parent.view;
        Image image2 = index == 0 ? this.image : (image = this.images != null ? this.images[index] : null);
        if (this.parent.columnCount == 0) {
            index = (this.parent.style & 0x20) != 0 ? 1 : 0;
        } else {
            TableColumn column = this.parent.getColumn(index);
            index = this.parent.indexOf(column.nsColumn);
        }
        NSRect rect = tableView.frameOfCellAtColumn(index, this.parent.indexOf(this));
        rect.x += 3.0f;
        rect.width = image != null ? (float)this.parent.imageBounds.width : 0.0f;
        return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    public int getImageIndent() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return 0;
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index == 0) {
            return this.getText();
        }
        if (this.strings != null && index >= 0 && index < this.strings.length) {
            String string = this.strings[index];
            return string != null ? string : "";
        }
        return "";
    }

    public Rectangle getTextBounds(int index) {
        Image image;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index < 0 || index >= Math.max(1, this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        NSTableView tableView = (NSTableView)this.parent.view;
        Image image2 = index == 0 ? this.image : (image = this.images != null ? this.images[index] : null);
        if (this.parent.columnCount == 0) {
            index = (this.parent.style & 0x20) != 0 ? 1 : 0;
        } else {
            TableColumn column = this.parent.getColumn(index);
            index = this.parent.indexOf(column.nsColumn);
        }
        NSRect rect = tableView.frameOfCellAtColumn(index, this.parent.indexOf(this));
        rect.x += 2.0f;
        rect.width -= 2.0f;
        if (image != null) {
            int offset = this.parent.imageBounds.width + 3;
            rect.x += (float)offset;
            rect.width -= (float)offset;
        }
        return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    boolean isDrawing() {
        return this.getDrawing() && this.parent.isDrawing();
    }

    void redraw(int columnIndex) {
        if (this.parent.currentItem == this || !this.isDrawing()) {
            return;
        }
        NSTableView tableView = (NSTableView)this.parent.view;
        NSRect rect = null;
        if (columnIndex == -1 || this.parent.hooks(41) || this.parent.hooks(40) || this.parent.hooks(42)) {
            rect = tableView.rectOfRow(this.parent.indexOf(this));
        } else {
            int index;
            if (this.parent.columnCount == 0) {
                index = (this.parent.style & 0x20) != 0 ? 1 : 0;
            } else if (columnIndex >= 0 && columnIndex < this.parent.columnCount) {
                index = this.parent.indexOf(this.parent.columns[columnIndex].nsColumn);
            } else {
                return;
            }
            rect = tableView.frameOfCellAtColumn(index, this.parent.indexOf(this));
        }
        tableView.setNeedsDisplayInRect(rect);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
    }

    void releaseWidget() {
        super.releaseWidget();
        this.strings = null;
        this.images = null;
        this.foreground = null;
        this.background = null;
        this.font = null;
        this.cellForeground = null;
        this.cellBackground = null;
        this.cellFont = null;
    }

    public void setBackground(Color color) {
        Color oldColor;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if ((oldColor = this.background) == color) {
            return;
        }
        this.background = color;
        if (oldColor != null && oldColor.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(-1);
    }

    public void setBackground(int index, Color color) {
        Color oldColor;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellBackground == null) {
            if (color == null) {
                return;
            }
            this.cellBackground = new Color[count];
        }
        if ((oldColor = this.cellBackground[index]) == color) {
            return;
        }
        this.cellBackground[index] = color;
        if (oldColor != null && oldColor.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(index);
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checked == checked) {
            return;
        }
        this.checked = checked;
        this.cached = true;
        this.redraw(-1);
    }

    public void setFont(Font font) {
        Font oldFont;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        if ((oldFont = this.font) == font) {
            return;
        }
        this.font = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        this.width = -1;
        this.cached = true;
        this.redraw(-1);
    }

    public void setFont(int index, Font font) {
        Font oldFont;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellFont == null) {
            if (font == null) {
                return;
            }
            this.cellFont = new Font[count];
        }
        if ((oldFont = this.cellFont[index]) == font) {
            return;
        }
        this.cellFont[index] = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        this.width = -1;
        this.cached = true;
        this.redraw(index);
    }

    public void setForeground(Color color) {
        Color oldColor;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if ((oldColor = this.foreground) == color) {
            return;
        }
        this.foreground = color;
        if (oldColor != null && oldColor.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(-1);
    }

    public void setForeground(int index, Color color) {
        Color oldColor;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellForeground == null) {
            if (color == null) {
                return;
            }
            this.cellForeground = new Color[count];
        }
        if ((oldColor = this.cellForeground[index]) == color) {
            return;
        }
        this.cellForeground[index] = color;
        if (oldColor != null && oldColor.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(index);
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == grayed) {
            return;
        }
        this.grayed = grayed;
        this.cached = true;
        this.redraw(-1);
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        int i = 0;
        while (i < images.length) {
            this.setImage(i, images[i]);
            ++i;
        }
    }

    public void setImage(int index, Image image) {
        int itemIndex;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((itemIndex = this.parent.indexOf(this)) == -1) {
            return;
        }
        if (this.parent.imageBounds == null && image != null) {
            this.parent.setItemHeight(image, null, false);
        }
        if (index == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            this.width = -1;
            super.setImage(image);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index >= 0 && index < count) {
            if (this.images == null) {
                this.images = new Image[count];
            }
            if (image != null && image.type == 1 && image.equals(this.images[index])) {
                return;
            }
            this.images[index] = image;
        }
        this.cached = true;
        if (index == 0) {
            this.parent.setScrollWidth(this);
        }
        this.redraw(index);
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImageIndent(int indent) {
        this.checkWidget();
        if (indent < 0) {
            return;
        }
        this.cached = true;
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.setText(i, string);
            }
            ++i;
        }
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index == 0) {
            if (string.equals(this.text)) {
                return;
            }
            this.width = -1;
            super.setText(string);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index >= 0 && index < count) {
            if (this.strings == null) {
                this.strings = new String[count];
            }
            if (string.equals(this.strings[index])) {
                return;
            }
            this.strings[index] = string;
        }
        this.cached = true;
        if (index == 0) {
            this.parent.setScrollWidth(this);
        }
        this.redraw(index);
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }
}

