/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.nodejs;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.server.cf.ds.IDeploymentPlanner;
import org.eclipse.orion.server.cf.ds.objects.Plan;
import org.eclipse.orion.server.cf.ds.objects.Procfile;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.manifest.v2.utils.ManifestUtils;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeJSDeploymentPlanner
implements IDeploymentPlanner {
    protected final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    public static String TYPE = "node.js";

    @Override
    public String getId() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public String getWizardId() {
        return "org.eclipse.orion.client.cf.wizard.nodejs";
    }

    protected String getApplicationName(IFileStore contentLocation) {
        String folderName = contentLocation.fetchInfo().getName();
        String[] folderNameParts = (folderName = folderName.replaceFirst(" \\| ", " --- ")).split(" --- ", 2);
        if (folderNameParts.length > 1) {
            return folderNameParts[1];
        }
        return folderNameParts[0];
    }

    protected String getApplicationHost(IFileStore contentLocation) {
        String folderName = contentLocation.fetchInfo().getName();
        folderName = folderName.replaceFirst(" \\| ", " --- ");
        return ManifestUtils.slugify(folderName);
    }

    protected void set(ManifestParseTree application, String property, String defaultValue) {
        if (application.has(property)) {
            return;
        }
        application.put(property, defaultValue);
    }

    protected String getProcfileCommand(IFileStore contentLocation) {
        String string;
        IFileStore procfileStore = contentLocation.getChild("Procfile");
        if (!procfileStore.fetchInfo().exists()) {
            return null;
        }
        InputStream is = null;
        try {
            is = procfileStore.openInputStream(0, null);
            Procfile procfile = Procfile.load(is);
            string = (String)procfile.get("web");
        }
        catch (Exception exception) {
            try {}
            catch (Throwable throwable) {
                IOUtilities.safeClose(is);
                throw throwable;
            }
            IOUtilities.safeClose((Closeable)is);
            return null;
        }
        IOUtilities.safeClose((Closeable)is);
        return string;
    }

    protected String getPackageCommand(IFileStore contentLocation) {
        InputStream is;
        block5: {
            String string;
            IFileStore packageStore = contentLocation.getChild("package.json");
            if (!packageStore.fetchInfo().exists()) {
                return null;
            }
            is = null;
            try {
                JSONObject scripts;
                is = packageStore.openInputStream(0, null);
                JSONObject packageJSON = new JSONObject(new JSONTokener((Reader)new InputStreamReader(is)));
                if (!packageJSON.has("scripts") || !(scripts = packageJSON.getJSONObject("scripts")).has("start")) break block5;
                string = scripts.getString("start");
            }
            catch (Exception exception) {
                try {}
                catch (Throwable throwable) {
                    IOUtilities.safeClose(is);
                    throw throwable;
                }
                IOUtilities.safeClose((Closeable)is);
                return null;
            }
            IOUtilities.safeClose((Closeable)is);
            return string;
        }
        IOUtilities.safeClose((Closeable)is);
        return null;
    }

    protected String getConventionCommand(IFileStore contentLocation) {
        IFileStore serverJS = contentLocation.getChild("server.js");
        if (serverJS.fetchInfo().exists()) {
            return "node server.js";
        }
        IFileStore appJS = contentLocation.getChild("app.js");
        if (appJS.fetchInfo().exists()) {
            return "node app.js";
        }
        return null;
    }

    @Override
    public Plan getDeploymentPlan(IFileStore contentLocation, ManifestParseTree manifest, IFileStore manifestStore) {
        IFileStore packageStore;
        IFileStore appStore = contentLocation;
        try {
            ManifestParseTree application;
            if (manifest != null && (application = manifest.get("applications").get(0)).has("path")) {
                appStore = contentLocation.getFileStore((IPath)new Path(application.get("path").getValue()));
            }
        }
        catch (InvalidAccessException e) {
            this.logger.error("Problem while reading manifest", (Throwable)e);
        }
        if (!(packageStore = appStore.getChild("package.json")).fetchInfo().exists()) {
            return null;
        }
        if (manifest != null && ManifestUtils.hasMultipleApplications(manifest)) {
            return null;
        }
        try {
            String manifestPath;
            if (manifest == null) {
                manifest = ManifestUtils.createBoilerplate(this.getApplicationName(contentLocation));
                manifestPath = null;
            } else {
                manifestPath = contentLocation.toURI().relativize(manifestStore.toURI()).toString();
            }
            ManifestParseTree application = manifest.get("applications").get(0);
            String defaultName = this.getApplicationName(contentLocation);
            this.set(application, "name", defaultName);
            this.set(application, "host", this.getApplicationHost(contentLocation));
            this.set(application, "memory", "512M");
            this.set(application, "instances", "1");
            this.set(application, "path", ".");
            if (application.has("command")) {
                return new Plan(this.getId(), this.getWizardId(), TYPE, manifest, manifestPath);
            }
            String command = this.getProcfileCommand(appStore);
            if (command != null) {
                return new Plan(this.getId(), this.getWizardId(), TYPE, manifest, manifestPath);
            }
            command = this.getPackageCommand(appStore);
            if (command != null) {
                return new Plan(this.getId(), this.getWizardId(), TYPE, manifest, manifestPath);
            }
            command = this.getConventionCommand(appStore);
            if (command != null) {
                application.put("command", command);
                return new Plan(this.getId(), this.getWizardId(), TYPE, manifest, manifestPath);
            }
            Plan plan = new Plan(this.getId(), this.getWizardId(), TYPE, manifest, manifestPath);
            plan.addRequired("command");
            return plan;
        }
        catch (Exception ex) {
            String msg = NLS.bind((String)"Failed to handle generic deployment plan for {0}", (Object)contentLocation.toString());
            this.logger.error(msg, (Throwable)ex);
            return null;
        }
    }
}

