/*******************************************************************************
 * @license
 * Copyright (c) 2013 IBM Corporation.
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0
 * (http://www.eclipse.org/legal/epl-v10.html), and the Eclipse Distribution
 * License v1.0 (http://www.eclipse.org/org/documents/edl-v10.html).
 *
 * Contributors:
 *     IBM Corporation - Initial API and implementation
 ******************************************************************************/

// this file was generated by a script from the model in types.js
 /*eslint-env amd*/
define('javascript/contentAssist/indexFiles/browserIndex', [
], function () {
	return {
		"!name": "browser",
		"DocumentFragment": {
			"!proto": "Node",
			"!type": "fn()",
			"!doc": "The DocumentFragment interface represents a minimal document object that has no parent. It is used as a light-weight version of Document to store well-formed or potentially non-well-formed fragments of XML.",
			"!url": "https://developer.mozilla.org/en-US/docs/Web/API/DocumentFragment",
			"prototype": {
    			"querySelector": {
    				"!type": "fn(selectors: DOMString)",
    				"!doc": "The DocumentFragment.querySelector() method returns the first element, or null if no matches are found, within the DocumentFragment (using depth-first pre-order traversal of the document's nodes) that matches the specified group of selectors.",
    				"!url": "https://developer.mozilla.org/en-US/docs/Web/API/DocumentFragment.querySelector"
    			},
    			"querySelectorAll": {
    				"!type": "fn(selectors: DOMString) -> NodeList",
    				"!doc": "The DocumentFragment.querySelectorAll() method returns a NodeList of elements within the DocumentFragment (using depth-first pre-order traversal of the document's nodes) that matches the specified group of selectors.",
    				"!url": "https://developer.mozilla.org/en-US/docs/Web/API/DocumentFragment.querySelectorAll"
    			}
			}
		},
		"Event": {
			"!proto": "Object",
			"!type": "fn(type: String)",
			"!doc": "Event handlers may be attached to various objects including DOM elements, document, the window object, etc. When an event occurs, an event object is created and passed sequentially to the event listeners.",
			"!url": "https://developer.mozilla.org/en-US/docs/Web/API/Event",
			"prototype": {
    			"bubbles": "Boolean",
    			"cancelable": "Boolean",
    			"currentTarget": "Object",
    			"defaultPrevented": "Boolean",
    			"eventPhase": "Number",
    			"explicitOriginalTarget": "Object",
    			"originalTarget": "Object",
    			"target": "Object",
    			"timeStamp": "Number",
    			"isTrusted": "Boolean",
    			"initEvent": {
    				"!type": "fn(type: String, bubbles: Boolean, cancelable: Boolean)"
    			},
    			"preventDefault": {
    				"!type": "fn()"
    			},
    			"stopImmediatePropagation": {
    				"!type": "fn()"
    			},
    			"stopPropagation": {
    				"!type": "fn()"
    			}
			}
		},
		"Range": {
			"!proto": "Object",
			"!type": "fn()",
			"!doc": "The Range interface represents a fragment of a document that can contain nodes and parts of text nodes in a given document.",
			"!url": "https://developer.mozilla.org/en-US/docs/Web/API/Range",
			"prototype": {
			    "cloneContents": {
    				"!type": "fn() -> DocumentFragment"
    			},
    			"cloneRange": {
    				"!type": "fn() -> Range"
    			},
    			"commonAncestorContainer": {
    			    "!type": "Node",
    			    "!doc": "The Range.commonAncestorContainer read-only property returns the deepest, or further down the document tree, Node that contains both the Range.startContainer and Range.endContainer nodes.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/Range.commonAncestorContainer"
    			},
    			"collapse": {
    				"!type": "fn(toStart: Node)"
    			},
    			"collapsed": {
    			    "!type": "Boolean",
    			    "!doc": "The Range.collapsed read-only property returns a Boolean flag indicating whether the start and end points of the Range are at the same position. It returns true if the start and end boundary points of the Range are the same point in the DOM, false if not.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/Range.collapsed"
    			},
    			"compareBoundaryPoints": {
    				"!type": "fn(how: Object, sourceRange: Object) -> Number"
    			},
    			"comparePoint": {
    				"!type": "fn(node: Node, offset: Number) -> Number"
    			},
    			"deleteContents": {
    				"!type": "fn()"
    			},
    			"detach": {
    				"!type": "fn()"
    			},
    			"endContainer": {
    			    "!type": "Node",
    			    "!doc": "The Range.endContainer read-only property returns the Node within which the Range ends. To change the end position of a node, use the Range.setEnd() method or a similar one.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/Range.endContainer"
    			},
    			"endOffset": {
    			    "!type": "Number",
    			    "!doc": "The Range.endOffset read-only property returns a number representing where in the Range.endContainer the Range ends.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/Range.endOffset"
    			},
    			"extractContents": {
    				"!type": "fn() -> DocumentFragment"
    			},
    			"intersectsNode": {
    				"!type": "fn(node: Node) -> Boolean"
    			},
    			"isPointInRange": {
    				"!type": "fn(node: Node, offset: Number) -> Boolean"
    			},
    			"startContainer": {
    			    "!type": "Node",
    			    "!doc": "The Range.startContainer read-only property returns the Node within which the Range starts. To change the start position of a node, use one of the Range.setStart() methods.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/Range.startContainer"
    			},
    			"startOffset": {
    			    "!type": "Number",
    			    "!doc": "The Range.startOffset read-only property returns a number representing where in the startContainer the Range starts.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/Range.startOffset"
    			},
    			"selectNode": {
    				"!type": "fn(refNode: Node)"
    			},
    			"selectNodeContents": {
    				"!type": "fn(refNode: Node)"
    			},
    			"setEnd": {
    				"!type": "fn(refNode: Node, offset: Number)"
    			},
    			"setEndAfter": {
    				"!type": "fn(refNode: Node)"
    			},
    			"setEndBefore": {
    				"!type": "fn(refNode: Node)"
    			},
    			"setStart": {
    				"!type": "fn(refNode: Node, offset: Number)"
    			},
    			"setStartAfter": {
    				"!type": "fn(refNode: Node)"
    			},
    			"setStartBefore": {
    				"!type": "fn(refNode: Node)"
    			},
    			"surroundContents": {
    				"!type": "fn(nodeParent: Node)"
    			}
			}
		},
		"WebSocket": {
			"!proto": "Object",
			"!type": "fn(url: String, protocols: String)",
			"!url": "https://developer.mozilla.org/en/docs/WebSockets",
            "!doc": "WebSockets is an advanced technology that makes it possible to open an interactive communication session between the user's browser and a server. With this API, you can send messages to a server and receive event-driven responses without having to poll the server for a reply.",
			"prototype": {
			    "onreadystatechange": "EventListener",
    			"onopen": "EventListener",
    			"onerror": "EventListener",
    			"onclose": "EventListener",
    			"readyState": "Number",
    			"extensions": "String",
    			"protocol": "String",
    			"close": {
    				"!type": "fn(reason?: Object)"
    			},
    			"send": {
    				"!type": "fn(data: String)"
    			}
			}
		},
		"Worker": {
			"!proto": "Object",
			"!type": "fn(url: String)",
			"!url": "https://developer.mozilla.org/en/docs/DOM/Worker",
            "!doc": "Workers are background tasks that can be easily created and can send messages back to their creators. Creating a worker is as simple as calling the Worker() constructor, specifying a script to be run in the worker thread.",
			"prototype": {
			    "terminate": {
				"!type": "fn()"
    			},
    			"postMessage": {
    				"!type": "fn(message: String, transfer?: Object)"
    			},
    			"onmessage": {
    				"!type": "fn()"
    			}
			}
		},
		"XMLHttpRequest": {
			"!proto": "Object",
			"!type": "fn()",
			"!url": "https://developer.mozilla.org/en/docs/DOM/XMLHttpRequest",
            "!doc": "XMLHttpRequest is a JavaScript object that was designed by Microsoft and adopted by Mozilla, Apple, and Google. It's now being standardized in the W3C. It provides an easy way to retrieve data at a URL. Despite its name, XMLHttpRequest can be used to retrieve any type of data, not just XML, and it supports protocols other than HTTP (including file and ftp).",
            "prototype": {
    			"onreadystatechange": "EventListener",
    			"open": {
    				"!type": "fn(method: String, url: String, async?: Boolean, user?: String, password?: String)"
    			},
    			"setRequestHeader": {
    				"!type": "fn(header: String, value: String)"
    			},
    			"timeout": "Number",
    			"withCredentials": "Boolean",
    			"upload": "Object",
    			"send": {
    				"!type": "fn(data?: String)"
    			},
    			"abort": {
    				"!type": "fn()"
    			},
    			"getResponseHeader": {
    				"!type": "fn(header: String) -> String"
    			},
    			"getAllResponseHeaders": {
    				"!type": "fn() -> String"
    			},
    			"overrideMimeType": "Object",
    			"responseType": "Object",
    			"readyState": "Number",
    			"response": "Object",
    			"responseText": "String",
    			"responseXML": "Document",
    			"status": "Number",
    			"statusText": "String"
			}
		},
		"!define": {
		    "Console": {
    		    "!proto": "Object",
    		    "!url": "https://developer.mozilla.org/en/docs/DOM/console",
                "!doc": "The console object provides access to the browser's debugging console. The specifics of how it works vary from browser to browser, but there is a de facto set of features that are typically provided.",
    			"debug": {
    				"!type": "fn(msg: String)"
    			},
    			"dir": {
    				"!type": "fn(obj: Object)"
    			},
    			"error": {
    				"!type": "fn(msg: String)"
    			},
    			"group": {
    				"!type": "fn()"
    			},
    			"groupCollapsed": {
    				"!type": "fn()"
    			},
    			"groupEnd": {
    				"!type": "fn()"
    			},
    			"info": {
    				"!type": "fn(msg: String)"
    			},
    			"log": {
    				"!type": "fn(msg: String)"
    			},
    			"time": {
    				"!type": "fn(timerName: String)"
    			},
    			"timeEnd": {
    				"!type": "fn(timerName: String)"
    			},
    			"trace": {
    				"!type": "fn()"
    			},
    			"warn": {
    				"!type": "fn(msg: String)"
    			}
    		},
    		"CSSStyleDeclaration": {
				"!proto": "Object"
			},
		    "Document": {
    			"!proto": "Node",
    			"!doc": "Each web page loaded in the browser has its own document object. The Document interface serves as an entry point into the web page's content (the DOM tree, including elements such as <body> and <table>) and provides functionality which is global to the document (such as obtaining the page's URL and creating new elements in the document).",
    			"!url": "https://developer.mozilla.org/en-US/docs/Web/API/document",
    			"implementation": "DOMImplementation",
    			"URL": "String",
    			"documentURI": "String",
    			"compatMode": "String",
    			"characterSet": "String",
    			"contentType": "String",
    			"doctype": "DocumentType",
    			"documentElement": "Element",
    			"getElementsByTagName": {
    				"!type": "fn(localName: String) -> HTMLCollection"
    			},
    			"getElementsByTagNameNS": {
    				"!type": "fn(namespace: String, localName: String) -> HTMLCollection"
    			},
    			"getElementsByClassName": {
    				"!type": "fn(classNames: String) -> HTMLCollection"
    			},
    			"getElementById": {
    				"!type": "fn(elementId: String) -> Element"
    			},
    			"createElement": {
    				"!type": "fn(elementId: String) -> Element"
    			},
    			"createElementNS": {
    				"!type": "fn(namespace: String, qualifiedName: String) -> Element"
    			},
    			"createDocumentFragment": {
    				"!type": "fn() -> DocumentFragment"
    			},
    			"createTextNode": {
    				"!type": "fn(data: String) -> Text"
    			},
    			"createComment": {
    				"!type": "fn(data: String) -> Comment"
    			},
    			"createProcessingInstruction": {
    				"!type": "fn(target: String, data: String) -> ProcessingInstruction"
    			},
    			"importNode": {
    				"!type": "fn(node: Node, deep?: Boolean) -> Node"
    			},
    			"adoptNode": {
    				"!type": "fn(node: Node) -> Node"
    			},
    			"createEvent": {
    				"!type": "fn(eventInterfaceName: String) -> Event"
    			},
    			"createRange": {
    				"!type": "fn() -> Range"
    			},
    			"createNodeIterator": {
    				"!type": "fn(root: Node, whatToShow?: Object, filter?: Object) -> NodeIterator"
    			},
    			"createTreeWalker": {
    				"!type": "fn(root: Node, whatToShow?: Object, filter?: Object) -> TreeWalker",
    				"!doc": "The Document.createTreeWalker() creator method returns a newly created TreeWalker object.",
    				"!url": "https://developer.mozilla.org/en-US/docs/Web/API/Document.createTreeWalker"
    			}
    		},
    		"DocumentType": {
    			"!proto": "Node",
    			"!doc": "The DocumentType interface represents a Node containing a doctype.",
    			"!url": "https://developer.mozilla.org/en-US/docs/Web/API/DocumentType",
    			"name": "String",
    			"publicId": "String",
    			"systemId": "String"
    		},
    		"DOMApplicationCache": {
    			"!proto": "Object",
    			"!doc": "A DOMApplicationCache object is used to store resources—such as, HTML, JavaScript, CSS, and images—locally. This allows your web application to continue running offline when there is no network connection. The cache persists after Safari exits, so it can be used by multiple browser sessions. There is one application cache per browsing context.",
    			"!url": "https://developer.apple.com/library/iad/documentation/DataManagement/Reference/DOMApplicationCacheClassReference/DOMApplicationCache/DOMApplicationCache.html",
    		},
    		"DOMImplementation": {
    			"!proto": "Object",
    			"!doc": "The DOMImplementation interface represent an object providing methods which are not dependent on any particular document. Such an object is returned by the Document.implementation property.",
    			"!url": "https://developer.mozilla.org/en-US/docs/Web/API/DOMImplementation",
    			"createDocumentType": {
    				"!type": "fn(qualifiedName: String, publicId: String, systemId: String) -> DocumentType",
    				"!doc": "The DOMImplementation.createDocumentType() method returns a DocumentType object which can either be used with DOMImplementation.createDocument upon document creation or can be put into the document via methods like Node.insertBefore() or Node.replaceChild().",
    				"!url": "https://developer.mozilla.org/en-US/docs/Web/API/DOMImplementation.createDocumentType"
    			},
    			"createDocument": {
    				"!type": "fn(namespace: String, qualifiedName: String, doctype: String) -> Document",
    				"!doc": "The DOMImplementation.createDocument() method creates and returns a Document.",
    				"!url": "https://developer.mozilla.org/en-US/docs/Web/API/DOMImplementation.createDocument"
    			},
    			"createHTMLDocument": {
    				"!type": "fn(title: String) -> Document",
    				"!doc": "The DOMImplementation.createHTMLDocument() method creates a new HTML Document.",
    				"!url": "https://developer.mozilla.org/en-US/docs/Web/API/DOMImplementation.createHTMLDocument"
    			},
    			"hasFeature": {
    				"!type": "fn(feature: String) -> Boolean",
    				"!doc": "The DOMImplementation.hasFeature() method returns a Boolean flag indicating if a given feature is supported.",
    				"!url": "https://developer.mozilla.org/en-US/docs/Web/API/DOMImplementation.hasFeature"
    			}
    		},
    		"DOMString": {
    		    "!proto": "String",
    		    "!doc": "A UTF-16 String. As JavaScript already uses such strings, DOMString is mapped directly to a String.",
    		    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/DOMString"
    		},
    		"DOMStringMap": {
    		    "!proto": "Object",
    		    "!doc": "Used by the dataset HTML attribute to represent data for custom attributes added to elements.",
    		    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/DOMStringMap"
    		},
    		"DOMTokenList": {
    			"!proto": "Object",
    			"!doc": "The DOMTokenList interface represents a set of space-separated tokens. Such a set is returned by Element.classList, HTMLLinkElement.relList, HTMLAnchorElement.relList or HTMLAreaElement.relList. It is indexed beginning with 0 as with JavaScript Array objects. DOMTokenList is always case-sensitive.",
    			"!url": "https://developer.mozilla.org/en-US/docs/Web/API/DOMTokenList",
    			"length": "Number",
    			"item": {
    				"!type": "fn(index: Number) -> String"
    			},
    			"contains": {
    				"!type": "fn(token: String) -> Boolean"
    			},
    			"add": {
    				"!type": "fn(token: String)"
    			},
    			"remove": {
    				"!type": "fn(token: String)"
    			},
    			"toggle": {
    				"!type": "fn(token: String) -> Boolean"
    			}
    		},
    		"Element": {
    			"!proto": "Node",
    			"!doc": "The Element interface represents an object of a Document. This interface describes methods and properties common to all kinds of elements. Specific behaviors are described in interfaces which inherit from Element but add additional functionality. For example, the HTMLElement interface is the base interface for HTML elements, while the SVGElement interface is the basis for all SVG elements.",
    			"!url": "https://developer.mozilla.org/en-US/docs/Web/API/Element",
    			"namespaceURI": "String",
    			"prefix": "String",
    			"localName": "String",
    			"tagName": "String",
    			"id": "String",
    			"className": "String",
    			"classList": "DOMTokenList",
    			"attributes": "Array",
    			"childElementCount": "Number",
    			"children": "HTMLCollection",
    			"firstElementChild": "Element",
    			"lastElementChild": "Element",
    			"previousElementSibling": "Element",
    			"nextElementSibling": "Element",
    			"getAttribute": {
    				"!type": "fn(name: String) -> String"
    			},
    			"getAttributeNS": {
    				"!type": "fn(namespace: String, localname: String) -> String"
    			},
    			"setAttribute": {
    				"!type": "fn(name: String, value: Object)"
    			},
    			"setAttributeNS": {
    				"!type": "fn(namespace: String, name: String, value: Object)"
    			},
    			"removeAttribute": {
    				"!type": "fn(name: String)"
    			},
    			"removeAttributeNS": {
    				"!type": "fn(namespace: String, localname: String)"
    			},
    			"hasAttribute": {
    				"!type": "fn(name: String) -> Boolean"
    			},
    			"hasAttributeNS": {
    				"!type": "fn(namespace: String, localname: String) -> Boolean"
    			},
    			"getElementsByTagName": {
    				"!type": "fn(localName: String) -> HTMLCollection"
    			},
    			"getElementsByTagNameNS": {
    				"!type": "fn(namespace: String, localName: String) -> HTMLCollection"
    			},
    			"getElementsByClassName": {
    				"!type": "fn(classname: String) -> HTMLCollection"
    			},
    			"prepend": {
    				"!type": "fn(nodes: Node)"
    			},
    			"append": {
    				"!type": "fn(nodes: Node)"
    			},
    			"before": {
    				"!type": "fn(nodes: Node)"
    			},
    			"after": {
    				"!type": "fn(nodes: Node)"
    			},
    			"replace": {
    				"!type": "fn(nodes: Node)"
    			},
    			"remove": {
    				"!type": "fn()"
    			}
    		},
			"EventListener": {
			    "!proto": "Object",
			    "!doc": "The EventListener interface is the primary method for handling events. Users implement the EventListener interface and register their listener on an EventTarget using the AddEventListener method. The users should also remove their EventListener from its EventTarget after they have completed using the listener.",
			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/EventListener",
		        "handleEvent": {
		            "!type": "fn(event: Event)",
		            "!doc": "This method is called whenever an event occurs of the type for which the EventListener interface was registered.",
		            "!url": "https://developer.mozilla.org/en-US/docs/Web/API/EventListener#handleEvent()"
		         }
			},
			"EventTarget": {
			    "!proto": "Object",
			    "!doc": "EventTarget is a DOM interface implemented by objects that can receive DOM events and have listeners for them.",
			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/EventTarget",
		        "addEventListener": {
		            "!type": "fn(type: String, listener: EventListener, useCapture?: Boolean)",
		            "!doc": "The EventTarget.addEventListener() method registers the specified listener on the EventTarget it's called on. The event target may be an Element in a document, the Document itself, a Window, or any other object that supports events (such as XMLHttpRequest).",
		            "!url": "https://developer.mozilla.org/en-US/docs/Web/API/EventTarget.addEventListener"
		        },
		        "dispatchEvent": {
		            "!type": "fn(event: Event)",
		            "!doc": "Dispatches an Event at the specified EventTarget, invoking the affected EventListeners in the appropriate order. The normal event processing rules (including the capturing and optional bubbling phase) apply to events dispatched manually with dispatchEvent().",
		            "!url": "https://developer.mozilla.org/en-US/docs/Web/API/EventTarget.dispatchEvent"
		        },
		        "removeEventListener": {
		            "!type": "fn(type: String, listener: EventListener, useCapture?: Boolean)",
		            "!doc": "Removes the event listener previously registered with EventTarget.addEventListener.",
		            "!url": "https://developer.mozilla.org/en-US/docs/Web/API/EventTarget.removeEventListener"
		        }
			},
			"HTMLCollection": {
    			"!proto": "Object",
    			"!doc": "An HTMLCollection in the HTML DOM is live; it is automatically updated when the underlying document is changed.",
    			"!url": "https://developer.mozilla.org/en-US/docs/Web/API/HTMLCollection",
    			"length": {
    			    "!type": "Number",
    			    "!doc": "Returns the number of items in the collection."
    			},
    			"item": {
    				"!type": "fn(index: Number) -> Element",
    				"!doc": "Returns the specific node at the given zero-based index into the list. Returns null if the index is out of range."
    			},
    			"namedItem": {
    				"!type": "fn(name: String) -> Element",
    				"!doc": "Returns the specific node whose ID or, as a fallback, name matches the string specified by name. Matching by name is only done as a last resort, only in HTML, and only if the referenced element supports the name attribute. Returns null if no node exists by the given name."
    			}
    		},
			"HTMLOptionElement": {
				"!proto": "HTMLElement",
				"!doc": "The HTMLOptionElement interface represents <option> elements and inherits all classes and methods of the HTMLElement interface.",
				"!url": "https://developer.mozilla.org/en-US/docs/Web/API/HTMLOptionElement"
			},
			"HTMLElement": {
				"!proto": "Element",
				"!doc": "The HTMLElement interface represents any HTML element. Some elements directly implement this interface, others implement it via an interface that inherits it.",
				"!url": "https://developer.mozilla.org/en-US/docs/Web/API/HTMLElement",
				"id": "String",
				"className": "String",
				"contentEditable": "DOMString",
				"isContentEditable": "Boolean",
				"dataset": "DOMStringMap",
				"dir": "DOMString",
				"lang": "DOMString",
				"offsetHeight": "Number",
				"offsetLeft": "Number",
				"offsetParent": "Element",
				"offsetTop": "Number",
				"offsetWidth": "Number",
				"style": "CSSStyleDeclaration",
				"tabIndex": "Number",
				"title": "DOMString"
			},
			"HTMLImageElement": {
				"!proto": "HTMLElement"
			},
			"Location": {
    			"!proto": "Object",
    			"!doc": "The Location interface represents the location of the object it is linked to. Changes done on it are reflected on the object it relates to. Both the Document and Window interface have such a linked Location, accessible via Document.location and Window.location respectively.",
    			"!url": "https://developer.mozilla.org/en-US/docs/Web/API/Location",
    			"href": "String",
    			"protocol": "String",
    			"host": "String",
    			"hostname": "String",
    			"port": "String",
    			"pathname": "String",
    			"search": "String",
    			"hash": "String",
    			"assign": {
    				"!type": "fn(url: String)",
    				"!doc": "The Location.assign()method causes the window to load and display the document at the URL specified.",
    				"!url": "https://developer.mozilla.org/en-US/docs/Web/API/Location.assign"
    			},
    			"reload": {
    				"!type": "fn()",
    				"!doc": "The Location.reload()method Reloads the resource from the current URL. Its optional unique parameter is a Boolean, which, when it is true, causes the page to always be reloaded from the server. If it is false or not specified, the browser may reload the page from its cache.",
    				"!url": "https://developer.mozilla.org/en-US/docs/Web/API/Location.reload"
    			},
    			"replace": {
    				"!type": "fn(url: String)",
    				"!doc": "The Location.replace()method replaces the current resource with the one at the provided URL. The difference from the assign() method is that after using replace() the current page will not be saved in session History, meaning the user won't be able to use the back button to navigate to it.",
    				"!url": "https://developer.mozilla.org/en-US/docs/Web/API/Location.replace"
    			}
    		},
			"MediaQueryList": {
				"!proto": "Object"
			},
			"Node": {
    			"!proto": "EventTarget",
    			"!doc": "A Node is an interface from which a number of DOM types inherit, and allows these various types to be treated (or tested) similarly.",
    			"!url": "https://developer.mozilla.org/en-US/docs/Web/API/Node",
    			"nodeType": "Number",
    			"nodeName": "String",
    			"baseURI": "String",
    			"ownerDocument": "Document",
    			"parentNode": "Node",
    			"parentElement": "Element",
    			"childNodes": "NodeList",
    			"firstChild": "Node",
    			"lastChild": "Node",
    			"previousSibling": "Node",
    			"nextSibling": "Node",
    			"nodeValue": "String",
    			"textContent": "String",
    			"hasChildNodes": {
    				"!type": "fn() -> Boolean"
    			},
    			"compareDocumentPosition": {
    				"!type": "fn(other: Node) -> Number"
    			},
    			"contains": {
    				"!type": "fn(other: Node) -> Boolean"
    			},
    			"insertBefore": {
    				"!type": "fn(child: Node) -> Node"
    			},
    			"appendChild": {
    				"!type": "fn(node: Node) -> Node"
    			},
    			"replaceChild": {
    				"!type": "fn(child: Node) -> Node"
    			},
    			"removeChild": {
    				"!type": "fn(child: Node) -> Node"
    			},
    			"normalize": {
    				"!type": "fn()"
    			},
    			"cloneNode": {
    				"!type": "fn(deep?: Boolean) -> Node"
    			},
    			"isEqualNode": {
    				"!type": "fn(node: Node) -> Boolean"
    			},
    			"lookupPrefix": {
    				"!type": "fn(namespace: String) -> String"
    			},
    			"lookupNamespaceURI": {
    				"!type": "fn(prefix: String) -> String"
    			},
    			"isDefaultNamespace": {
    				"!type": "fn(namespace: String) -> Boolean"
    			}
    		},
    		"NodeFilter": {
    		    "!proto": "Object",
    		    "!doc": "A NodeFilter interface represents an object used to filter the nodes in a NodeIterator or TreeWalker. They don't know anything about the DOM or how to traverse nodes; they just know how to evaluate a single node against the provided filter.",
    		    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/NodeFilter",
    		    "acceptNode": {
    		        "!type": "fn(node: Node) -> Number",
    		        "!doc": "The NodeFilter.acceptNode() method returns an unsigned short that will be used to tell if a given Node must be accepted or not by the NodeIterator or TreeWalker iteration algorithm. This method is expected to be written by the user of a NodeFilter. ",
    		        "!url": "https://developer.mozilla.org/en-US/docs/Web/API/NodeFilter.acceptNode"
    		    }
    		},
    		"NodeIterator": {
    			"!proto": "Object",
    			"!doc": "The NodeIterator interface represents an iterator over the members of a list of the nodes in a subtree of the DOM. The nodes will be returned in document order.",
    			"!url": "https://developer.mozilla.org/en-US/docs/Web/API/NodeIterator",
    			"whatToShow": {
    			    "!type": "Number",
    			    "!doc": "The NodeIterator.whatToShow read-only property represents an unsigned integer representing a bitmask signifying what types of nodes should be returned by the NodeIterator.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/NodeIterator.whatToShow"
    			},
    			"root": {
    			    "!type": "Node",
    			    "!doc": "The NodeIterator.root read-only property represents the Node that is the root of what the NodeIterator traverses.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/NodeIterator.root"
    			},
    			"filter": {
    			    "!type": "NodeFilter",
    			    "!doc": "The NodeIterator.filter read-only method returns a NodeFilter object, that is an object implement an acceptNode(node) method, used to screen nodes.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/NodeIterator.filter"
    			},
    			"expandEntityReferences": {
    			    "!type": "Boolean",
    			    "!doc": "The NodeIterator.expandEntityReferences read-only property returns a Boolean flag indicating whether or not the children of entity reference nodes are visible to the NodeIterator.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/NodeIterator.expandEntityReferences"
    			},
    			"nextNode": {
    			    "!type": "fn() -> Node",
    			    "!doc": "The NodeIterator.nextNode() method returns the next node in the set represented by the NodeIterator and advances the position of the iterator within the set.  The first call to nextNode() returns the first node in the set.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/NodeIterator.nextNode"
    			},
    			"referenceNode": {
    			    "!type": "Node",
    			    "!doc": "The NodeIterator.referenceNode read-only returns the Node to which the iterator is anchored; as new nodes are inserted, the iterator remains anchored to the reference node as specified by this property.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/NodeIterator.referenceNode"
    			},
    			"pointerBeforeReferenceNode": {
    			    "!type": "Boolean",
    			    "!doc": "The NodeIterator.pointerBeforeReferenceNode read-only property returns a Boolean flag that indicates whether the NodeFilter is anchored before (if this value is true) or after (if this value is false) the anchor node indicated by the NodeIterator.referenceNode property.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/NodeIterator.pointerBeforeReferenceNode"
    			},
    			"previousNode": {
    			    "!type": "fn() -> Node",
    			    "!doc": "The NodeIterator.previousNode() method returns the previous node in the set represented by the NodeIterator and moves the position of the iterator backwards within the set.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/NodeIterator.previousNode"
    			}
    		},
    		"NodeList": {
    			"!proto": "Object",
    			"!url": "https://developer.mozilla.org/en/docs/DOM/NodeList",
                "!doc": "NodeList objects are collections of nodes returned by getElementsByTagName, getElementsByTagNameNS, Node.childNodes, querySelectorAll, getElementsByClassName, etc.",
    			"item": {
    			    "!type": "fn(idx: Number) -> Node",
    			    "!doc": "Returns a node from a NodeList by index.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/NodeList.item"
    			},
    			"length": {
    			    "!type": "Number",
    			    "!doc": "The number of nodes in the NodeList."
    			 }
    		},
			"Selection": {
				"!proto": "Object",
				"anchorNode": "Node",
				"anchorOffset": "Number",
				"focusNode": "Node",
				"focusOffset": "Number",
				"rangeCount": "Number",
				"isCollapsed": "Boolean",
				"collapse": {
					"!type": "fn(node: Node, offset: Number)"
				},
				"collapseToStart": {
					"!type": "fn()"
				},
				"collapseToEnd": {
					"!type": "fn()"
				},
				"extend": {
					"!type": "fn(node: Node, offset: Number)"
				},
				"selectAllChildren": {
					"!type": "fn(node: Node)"
				},
				"deleteFromDocument": {
					"!type": "fn()"
				},
				"getRangeAt": {
					"!type": "fn(index: Number) -> Range"
				},
				"addRange": {
					"!type": "fn(range: Range)"
				},
				"removeRange": {
					"!type": "fn(range: Range)"
				},
				"removeAllRanges": {
					"!type": "fn()"
				}
			},
			"TreeWalker": {
    			"!proto": "Object",
    			"!doc": "The TreeWalker object represents the nodes of a document subtree and a position within them.",
    			"!url": "https://developer.mozilla.org/en-US/docs/Web/API/TreeWalker",
    			"currentNode": {
    			    "!type": "Node",
    			    "!doc": "The TreeWalker.currentNode property represents the Node on which the TreeWalker is currently pointing at.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/TreeWalker.currentNode"
    			},
    			"whatToShow": {
    			    "!type": "Number",
    			    "!doc": "The TreeWalker.whatToShow read-only property returns an unsigned long being a bitmask made of constants describing the types of Node that must to be presented. Non-matching nodes are skipped, but their children may be included, if relevant.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/TreeWalker.whatToShow"
    			},
    			"root": {
    			    "!type": "Node",
    			    "!doc": "The TreeWalker.root read-only property returns the node that is the root of what the TreeWalker traverses.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/TreeWalker.root"
    			},
    			"filter": {
    			    "!type": "NodeFilter",
    			    "!doc": "The TreeWalker.filter read-only property returns a NodeFilter that is the filtering object associated with the TreeWalker.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/TreeWalker.filter"
    			},
    			"parentNode": {
    			    "!type": "fn() -> Node",
    			    "!doc": "The TreeWalker.parentNode() method moves the current Node to the first visible ancestor node in the document order, and returns the found node. If no such node exists, or if it is above the TreeWalker's root node, returns null and the current node is not changed.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/TreeWalker.parentNode"
    			},
    			"firstChild": {
    			    "!type": "fn() -> Node",
    			    "!doc": "The TreeWalker.firstChild() method moves the current Node to the first visible child of the current node, and returns the found child. It also moves the current node to this child. If no such child exists, returns null and the current node is not changed.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/TreeWalker.firstChild"
    			},
    			"lastChild": {
    			    "!type": "fn() -> Node",
    			    "!doc": "The TreeWalker.lastChild() method moves the current Node to the last visible child of the current node, and returns the found child. It also moves the current node to this child. If no such child exists, returns null and the current node is not changed.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/TreeWalker.lastChild"
    			},
    			"previousSibling": {
    			    "!type": "fn() -> Node",
    			    "!doc": "The TreeWalker.previousSibling() method moves the current Node to its previous sibling, if any, and returns the found sibling. I there is no such node, return null and the current node is not changed.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/TreeWalker.previousSibling"
    			},
    			"nextSibling": {
    			    "!type": "fn() -> Node",
    			    "!doc": "The TreeWalker.nextSibling() method moves the current Node to its next sibling, if any, and returns the found sibling. I there is no such node, return null and the current node is not changed.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/TreeWalker.nextSibling"
    			},
    			"nextNode": {
    			    "!type": "fn() -> Node",
    			    "!doc": "The TreeWalker.nextNode() method moves the current Node to the next visible node in the document order, and returns the found node. It also moves the current node to this one. If no such node exists, returns null and the current node is not changed.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/TreeWalker.nextNode"
    			},
    			"previousNode": {
    			    "!type": "fn() -> Node",
    			    "!doc": "The TreeWalker.previousNode() method moves the current Node to the previous visible node in the document order, and returns the found node. It also moves the current node to this one. If no such node exists,or if it is before that the root node defined at the object construction, returns null and the current node is not changed.",
    			    "!url": "https://developer.mozilla.org/en-US/docs/Web/API/TreeWalker.previousNode"
    			}
    		},
			"Screen": {
				"!proto": "Object",
				"availTop": "Number",
				"availLeft": "Number",
				"availHeight": "Number",
				"availWidth": "Number",
				"colorDepth": "Number",
				"height": "Number",
				"left": "Number",
				"pixelDepth": "Number",
				"top": "Number",
				"width": "Number"
			},
			"Performance": {
				"!proto": "Object"
			},
			"Navigator": {
				"!proto": "Object",
				"appName": "String",
				"appVersion": "String",
				"connection": "Connection",
				"cookieEnabled": "Boolean",
				"language": "String",
				"mimeTypes": "MimeTypeArray",
				"onLine": "Boolean",
				"oscpu": "String",
				"platform": "String",
				"plugins": "String",
				"userAgent": "String",
				"javaEnabled": {
					"!type": "fn() -> Boolean"
				},
				"registerContentHandler": {
					"!type": "fn(mimType: String, url: String, title: String)"
				},
				"registerProtocolHandler": {
					"!type": "fn(protocol: String, url: String, title: String)"
				}
			},
			"MimeTypeArray": {
				"length": "Number",
				"item": {
					"!type": "fn(index: Number) -> MimeType"
				},
				"namedItem": {
					"!type": "fn(name: String) -> MimeType"
				}
			},
			"MimeType": {
				"description": "String",
				"suffixes": "String",
				"type": "String",
				"enabledPlugin": "Plugin"
			},
			"Plugin": {
				"description": "String",
				"fileName": "String",
				"length": "Number",
				"name": "String",
				"item": {
					"!type": "fn(index: Number) -> MimeType"
				},
				"namedItem": {
					"!type": "fn(name: String) -> MimeType"
				}
			},
			"Connection": {
				"bandwidth": "Number",
				"metered": "Boolean",
				"onchange": "Function"
			},
			"Storage": {
				"!proto": "Object",
				"length": "Number",
				"key": {
					"!type": "fn(idx: Number) -> String"
				},
				"getItem": {
					"!type": "fn(key: String) -> String"
				},
				"setItem": {
					"!type": "fn(key: String, value: String)"
				},
				"removeItem": {
					"!type": "fn(key: String)"
				},
				"clear": {
					"!type": "fn()"
				}
			},
			"BarInfo": {
				"!proto": "Object",
				"visible": "Boolean"
			},
			
			"History": {
				"!proto": "Object",
				"length": "Number",
				"state": "Object",
				"go": {
					"!type": "fn(delta: Number)"
				},
				"back": {
					"!type": "fn()"
				},
				"forward": {
					"!type": "fn()"
				},
				"pushState": {
					"!type": "fn(data: Object, title: String, url: String)"
				},
				"replaceState": {
					"!type": "fn(data: Object, title: String, url: String)"
				}
			},
			
			"ProcessingInstruction": {
				"!proto": "Node"
			},
			"Comment": {
				"!proto": "Node"
			},
			"Text": {
				"!proto": "Node"
			},
			
		},
		"this": "<top>",
		"top": "<top>",
		"window": "<top>",
		"alert": {
		    "!type": "fn(msg: String)"
		 },
		"applicationCache": "DOMApplicationCache",
		"atob": {
			"!type": "fn(val: Object) -> String"
		},
		"back": {
			"!type": "fn()"
		},
		"blur": {
			"!type": "fn()"
		},
		"btoa": {
			"!type": "fn(val: Object) -> String"
		},
		"closed": "Boolean",
		"console": "Console",
		"defaultStatus": "String",
		"document": "Document",
		"frameElement": "Element",
		"frames": "Array",
		"history": "History",
		"innerHeight": "Number",
		"innerWidth": "Number",
		"length": "Number",
		"location": "Location",
		"locationbar": "BarInfo",
		"localStorage": "Storage",
		"menubar": "BarInfo",
		"name": "String",
		"navigator": "Navigator",
		"opener": "<top>",
		"outerHeight": "Number",
		"outerWidth": "Number",
		"pageXOffset": "Number",
		"pageYOffset": "Number",
		"parent": "<top>",
		"performance": "Performance",
		"personalbar": "BarInfo",
		"screen": "Screen",
		"screenX": "Number",
		"screenY": "Number",
		"scrollbars": "BarInfo",
		"scrollMaxX": "Number",
		"scrollMaxY": "Number",
		"scrollX": "Number",
		"scrollY": "Number",
		"self": "<top>",
		"sessionStorage": "Storage",
		"sidebar": "BarInfo",
		"status": "String",
		"statusbar": "BarInfo",
		"toolbar": "BarInfo",
		"addEventListener": {
			"!type": "fn()"
		},
		"clearInterval": {
			"!type": "fn(t: Number)"
		},
		"clearTimeout": {
			"!type": "fn(t: Number)"
		},
		"close": {
			"!type": "fn()"
		},
		"confirm": {
			"!type": "fn(msg: String) -> Boolean"
		},
		"dispatchEvent": {
			"!type": "fn(domnode: Node)"
		},
		"dump": {
			"!type": "fn(msg: String)"
		},
		"escape": {
			"!type": "fn(str: String) -> String"
		},
		"find": {
			"!type": "fn(str: String) -> Boolean"
		},
		"focus": {
			"!type": "fn()"
		},
		"forward": {
			"!type": "fn()"
		},
		"getAttention": {
			"!type": "fn()"
		},
		"getComputedStyle": {
			"!type": "fn(domnode: Node) -> CSSStyleDeclaration"
		},
		"getSelection": {
			"!type": "fn() -> Selection"
		},
		"home": {
			"!type": "fn()"
		},
		"matchMedia": {
			"!type": "fn(query: Object) -> MediaQueryList"
		},
		"moveBy": {
			"!type": "fn(deltaX: Number, deltaY: Number)"
		},
		"moveTo": {
			"!type": "fn(x: Number, y: Number)"
		},
		"open": {
			"!type": "fn(strUrl: String, strWindowName: String, strWindowFeatures?: String) -> <top>"
		},
		"openDialog": {
			"!type": "fn(strUrl: String, strWindowName: String, strWindowFeatures: String, args?: String) -> <top>"
		},
		"postMessage": {
			"!type": "fn(message: String, targetOrigin: String)"
		},
		"print": {
			"!type": "fn()"
		},
		"prompt": {
			"!type": "fn(message: String) -> String"
		},
		"removeEventListener": {
			"!type": "fn(type: String, listener: Object, useCapture?: Boolean)"
		},
		"resizeBy": {
			"!type": "fn(deltaX: Number, deltaY: Number)"
		},
		"resizeTo": {
			"!type": "fn(x: Number, y: Number)"
		},
		"scroll": {
			"!type": "fn(x: Number, y: Number)"
		},
		"scrollBy": {
			"!type": "fn(deltaX: Number, deltaY: Number)"
		},
		"scrollByLines": {
			"!type": "fn(lines: Number)"
		},
		"scrollByPages": {
			"!type": "fn(pages: Number)"
		},
		"scrollTo": {
			"!type": "fn(x: Number, y: Number)"
		},
		"setCursor": {
			"!type": "fn(cursor: String)"
		},
		"setInterval": {
			"!type": "fn(callback: Function, ms: Number) -> Number"
		},
		"setTimeout": {
			"!type": "fn(callback: Function, ms: Number) -> Number"
		},
		"sizeToContent": {
			"!type": "fn()"
		},
		"stop": {
			"!type": "fn()"
		},
		"unescape": {
			"!type": "fn(str: String) -> String"
		},
		"updateCommands": {
			"!type": "fn(cmdName: String)"
		},
		"onabort": {
			"!type": "fn(event: Event)"
		},
		"onbeforeunload": {
			"!type": "fn(event: Event)"
		},
		"onblur": {
			"!type": "fn(event: Event)"
		},
		"onchange": {
			"!type": "fn(event: Event)"
		},
		"onclick": {
			"!type": "fn(event: Event)"
		},
		"onclose": {
			"!type": "fn(event: Event)"
		},
		"oncontextmenu": {
			"!type": "fn(event: Event)"
		},
		"ondevicemotion": {
			"!type": "fn(event: Event)"
		},
		"ondeviceorientation": {
			"!type": "fn(event: Event)"
		},
		"ondragdrop": {
			"!type": "fn(event: Event)"
		},
		"onerror": {
			"!type": "fn(event: Event)"
		},
		"onfocus": {
			"!type": "fn(event: Event)"
		},
		"onhashchange": {
			"!type": "fn(event: Event)"
		},
		"onkeydown": {
			"!type": "fn(event: Event)"
		},
		"onkeypress": {
			"!type": "fn(event: Event)"
		},
		"onkeyup": {
			"!type": "fn(event: Event)"
		},
		"onload": {
			"!type": "fn(event: Event)"
		},
		"onmousedown": {
			"!type": "fn(event: Event)"
		},
		"onmousemove": {
			"!type": "fn(event: Event)"
		},
		"onmouseout": {
			"!type": "fn(event: Event)"
		},
		"onmouseover": {
			"!type": "fn(event: Event)"
		},
		"onmouseup": {
			"!type": "fn(event: Event)"
		},
		"onpaint": {
			"!type": "fn(event: Event)"
		},
		"onpopstate": {
			"!type": "fn(event: Event)"
		},
		"onreset": {
			"!type": "fn(event: Event)"
		},
		"onresize": {
			"!type": "fn(event: Event)"
		},
		"onscroll": {
			"!type": "fn(event: Event)"
		},
		"onselect": {
			"!type": "fn(event: Event)"
		},
		"onsubmit": {
			"!type": "fn(event: Event)"
		},
		"onunload": {
			"!type": "fn(event: Event)"
		},
		"onpageshow": {
			"!type": "fn(event: Event)"
		},
		"onpagehide": {
			"!type": "fn(event: Event)"
		},
		"Image": {
			"!type": "fn(width?: Number, height?: Number)"
		},
		"Option": {
			"!type": "fn(text?: String, value?: Object, defaultSelected?: Boolean, selected?: Boolean)"
		}
	};
});