/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.ds;

import java.io.Closeable;
import java.io.InputStream;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.server.cf.ds.IDeploymentPlanner;
import org.eclipse.orion.server.cf.ds.objects.Plan;
import org.eclipse.orion.server.cf.ds.objects.Procfile;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.manifest.v2.utils.ManifestUtils;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GenericDeploymentPlanner
implements IDeploymentPlanner {
    protected final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    public static String TYPE = "generic";

    @Override
    public String getId() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public String getWizardId() {
        return "org.eclipse.orion.client.cf.wizard.generic";
    }

    protected String getApplicationName(IFileStore contentLocation) {
        String folderName = contentLocation.fetchInfo().getName();
        String[] folderNameParts = (folderName = folderName.replaceFirst(" \\| ", " --- ")).split(" --- ", 2);
        if (folderNameParts.length > 1) {
            return folderNameParts[1];
        }
        return folderNameParts[0];
    }

    protected String getApplicationHost(IFileStore contentLocation) {
        String folderName = contentLocation.fetchInfo().getName();
        folderName = folderName.replaceFirst(" \\| ", " --- ");
        return ManifestUtils.slugify(folderName);
    }

    private void set(ManifestParseTree application, String property, String defaultValue) {
        if (application.has(property)) {
            return;
        }
        application.put(property, defaultValue);
    }

    private String getProcfileCommand(IFileStore contentLocation) {
        String string;
        IFileStore procfileStore = contentLocation.getChild("Procfile");
        if (!procfileStore.fetchInfo().exists()) {
            return null;
        }
        InputStream is = null;
        try {
            is = procfileStore.openInputStream(0, null);
            Procfile procfile = Procfile.load(is);
            string = (String)procfile.get("web");
        }
        catch (Exception exception) {
            try {}
            catch (Throwable throwable) {
                IOUtilities.safeClose(is);
                throw throwable;
            }
            IOUtilities.safeClose((Closeable)is);
            return null;
        }
        IOUtilities.safeClose((Closeable)is);
        return string;
    }

    @Override
    public Plan getDeploymentPlan(IFileStore contentLocation, ManifestParseTree manifest, IFileStore manifestStore) {
        IFileStore appStore = contentLocation;
        try {
            ManifestParseTree application;
            if (manifest != null && (application = manifest.get("applications").get(0)).has("path")) {
                appStore = contentLocation.getFileStore((IPath)new Path(application.get("path").getValue()));
            }
        }
        catch (InvalidAccessException e) {
            this.logger.error("Problem while reading manifest", (Throwable)e);
        }
        try {
            String manifestPath;
            String applicationName = this.getApplicationName(contentLocation);
            if (manifest == null) {
                manifest = ManifestUtils.createBoilerplate(applicationName);
                manifestPath = null;
            } else {
                manifestPath = contentLocation.toURI().relativize(manifestStore.toURI()).toString();
            }
            ManifestParseTree application = manifest.get("applications").get(0);
            this.set(application, "host", this.getApplicationHost(contentLocation));
            this.set(application, "memory", "512M");
            this.set(application, "instances", "1");
            this.set(application, "path", ".");
            String procfileCommand = this.getProcfileCommand(appStore);
            if (procfileCommand != null) {
                this.set(application, "command", procfileCommand);
            }
            return new Plan(this.getId(), this.getWizardId(), TYPE, manifest, manifestPath);
        }
        catch (Exception ex) {
            String msg = NLS.bind((String)"Failed to handle generic deployment plan for {0}", (Object)contentLocation.toString());
            this.logger.error(msg, (Throwable)ex);
            return null;
        }
    }
}

