/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.manifest.v2.utils;

import java.util.UUID;
import org.eclipse.orion.server.cf.manifest.v2.Analyzer;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.manifest.v2.Token;

public class SymbolResolver
implements Analyzer {
    private String targetBase;

    public SymbolResolver(String targetBase) {
        this.targetBase = targetBase;
    }

    @Override
    public void apply(ManifestParseTree node) {
        if (node.getChildren().size() == 0) {
            for (Token token : node.getTokens()) {
                if (3 != token.getType()) continue;
                this.resolve(token);
            }
        } else {
            for (ManifestParseTree child : node.getChildren()) {
                this.apply(child);
            }
        }
    }

    private void resolve(Token token) {
        if (this.targetBase != null && "${target-base}".equals(token.getContent())) {
            token.setContent(this.targetBase);
            return;
        }
        if ("${random-word}".equals(token.getContent())) {
            token.setContent(UUID.randomUUID().toString());
            return;
        }
    }
}

