/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.manifest.v2.utils.ManifestUtils;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Domain;
import org.eclipse.orion.server.cf.objects.Route;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateRouteCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName;
    private Domain domain;
    private String hostName;
    private App app;
    private Route route;

    public CreateRouteCommand(Target target, Domain domain, String hostName) {
        super(target);
        this.domain = domain;
        this.hostName = hostName;
        this.commandName = NLS.bind((String)"Create a new route (domain guid: {0})", (Object)domain.getGuid());
    }

    public CreateRouteCommand(Target target, Domain domain, App app) {
        super(target);
        this.domain = domain;
        this.app = app;
        this.commandName = NLS.bind((String)"Create a new route (domain guid: {0})", (Object)domain.getGuid());
    }

    public Route getRoute() {
        return this.route;
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            URI routesURI = targetURI.resolve("/v2/routes");
            PostMethod createRouteMethod = new PostMethod(routesURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)createRouteMethod, this.target.getCloud());
            JSONObject routeRequest = new JSONObject();
            routeRequest.put("space_guid", (Object)this.target.getSpace().getCFJSON().getJSONObject("metadata").getString("guid"));
            routeRequest.put("host", (Object)this.hostName);
            routeRequest.put("domain_guid", (Object)this.domain.getGuid());
            createRouteMethod.setRequestEntity((RequestEntity)new StringRequestEntity(routeRequest.toString(), "application/json", "utf-8"));
            createRouteMethod.setQueryString("inline-relations-depth=1");
            ServerStatus createRouteStatus = HttpUtil.executeMethod((HttpMethodBase)createRouteMethod);
            if (!createRouteStatus.isOK()) {
                return createRouteStatus;
            }
            this.route = new Route().setCFJSON(createRouteStatus.getJsonData());
            return createRouteStatus;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }

    @Override
    protected IStatus validateParams() {
        try {
            if (this.app == null && this.hostName != null) {
                return Status.OK_STATUS;
            }
            if (this.app == null && this.hostName == null) {
                return new ServerStatus(4, 400, "Missing host name parameter", null);
            }
            ManifestParseTree manifest = this.app.getManifest();
            ManifestParseTree appNode = manifest.get("applications").get(0);
            String appName = null;
            appName = this.app.getName() != null ? this.app.getName() : appNode.get("name").getValue();
            ManifestParseTree hostNode = appNode.getOpt("host");
            this.hostName = hostNode != null ? hostNode.getValue() : ManifestUtils.slugify(appName);
            return Status.OK_STATUS;
        }
        catch (InvalidAccessException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
    }
}

