/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class LimitedInputStream
extends FilterInputStream {
    private long left;
    protected final long limit;
    private long mark = -1L;

    protected LimitedInputStream(InputStream in, long limit) {
        super(in);
        this.left = limit;
        this.limit = limit;
    }

    public int available() throws IOException {
        return (int)Math.min((long)this.in.available(), this.left);
    }

    public synchronized void mark(int readLimit) {
        this.in.mark(readLimit);
        this.mark = this.left;
    }

    public int read() throws IOException {
        int result;
        if (this.left == 0L) {
            if (this.in.available() == 0) {
                return -1;
            }
            this.limitExceeded();
        }
        if ((result = this.in.read()) != -1) {
            --this.left;
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result;
        if (this.left == 0L) {
            if (this.in.available() == 0) {
                return -1;
            }
            this.limitExceeded();
        }
        if ((result = this.in.read(b, off, len = (int)Math.min((long)len, this.left))) != -1) {
            this.left -= (long)result;
        }
        return result;
    }

    public synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.left = this.mark;
    }

    public long skip(long n) throws IOException {
        n = Math.min(n, this.left);
        long skipped = this.in.skip(n);
        this.left -= skipped;
        return skipped;
    }

    protected abstract void limitExceeded() throws IOException;
}

