/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.manifest.v2.utils;

import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.manifest.v2.Parser;
import org.eclipse.orion.server.cf.manifest.v2.ParserException;
import org.eclipse.orion.server.cf.manifest.v2.Token;
import org.eclipse.orion.server.cf.manifest.v2.Tokenizer;
import org.eclipse.orion.server.cf.manifest.v2.TokenizerException;

public class ManifestParser
implements Parser {
    private ManifestParseTree root;
    private ManifestParseTree currentParent;

    private Token getNextToken(Tokenizer tokenizer) throws TokenizerException {
        return tokenizer.hasNext() ? tokenizer.getNextToken() : null;
    }

    @Override
    public ManifestParseTree parse(Tokenizer tokenizer) throws TokenizerException, ParserException {
        this.currentParent = this.root = new ManifestParseTree();
        ManifestParseTree node = null;
        Token currentToken = this.getNextToken(tokenizer);
        Token nextToken = null;
        block5: while (currentToken != null) {
            switch (currentToken.getType()) {
                case 1: {
                    nextToken = this.getNextToken(tokenizer);
                    if (nextToken != null && 1 == nextToken.getType()) {
                        throw new ParserException("Unexpected token \"{1}\" around line {0}. Instead, expected a string literal or item symbol \"- \".", nextToken);
                    }
                    if (nextToken != null && nextToken.getLineNumber() == currentToken.getLineNumber()) {
                        node = new ManifestParseTree(currentToken.getIndentation());
                        node.getTokens().add(nextToken);
                        this.currentParent.getChildren().add(node);
                        node.setParent(this.currentParent);
                        while ((nextToken = this.getNextToken(tokenizer)) != null && nextToken.getLineNumber() == currentToken.getLineNumber()) {
                            node.getTokens().add(nextToken);
                        }
                    }
                    currentToken = nextToken;
                    continue block5;
                }
                case 2: {
                    node = new ManifestParseTree(currentToken.getIndentation());
                    node.getTokens().add(currentToken);
                    this.setItemFather(node.getLevel());
                    for (ManifestParseTree child : this.currentParent.getChildren()) {
                        if (child.isItemNode()) continue;
                        throw new ParserException("Unexpected item token \"{1}\" around line {0}. Instead, expected a string literal mapping, i.e. \"property : value\".", currentToken);
                    }
                    this.currentParent.getChildren().add(node);
                    node.setParent(this.currentParent);
                    nextToken = this.getNextToken(tokenizer);
                    if (nextToken != null && 4 != nextToken.getType()) {
                        throw new ParserException("Unexpected token \"{1}\" around line {0}. Instead, expected a string literal.", nextToken);
                    }
                    this.currentParent = node;
                    currentToken = nextToken;
                    continue block5;
                }
                case 3: 
                case 4: {
                    node = new ManifestParseTree(currentToken.getIndentation());
                    node.getTokens().add(currentToken);
                    this.setFather(node.getLevel());
                    for (ManifestParseTree child : this.currentParent.getChildren()) {
                        if (!child.isItemNode()) continue;
                        throw new ParserException("Unexpected string literal mapping \"{1}\" around line {0}. Instead, expected an item token, i.e. \" - property: value\".", currentToken);
                    }
                    this.currentParent.getChildren().add(node);
                    node.setParent(this.currentParent);
                    nextToken = this.getNextToken(tokenizer);
                    if (nextToken != null && 1 != nextToken.getType()) {
                        if (!this.currentParent.isItemNode()) {
                            throw new ParserException("Unexpected token \"{1}\" around line {0}. Instead, expected \":\".", nextToken);
                        }
                        if (nextToken != null && nextToken.getLineNumber() == currentToken.getLineNumber()) {
                            node.getTokens().add(nextToken);
                            while ((nextToken = this.getNextToken(tokenizer)) != null && nextToken.getLineNumber() == currentToken.getLineNumber()) {
                                node.getTokens().add(nextToken);
                            }
                        }
                    }
                    this.currentParent = node;
                    currentToken = nextToken;
                    continue block5;
                }
            }
            throw new ParserException("Unsupported token around line {0}.", currentToken);
        }
        return this.root;
    }

    private void setFather(int currentLevel) {
        while (this.currentParent != this.root && this.currentParent.getLevel() >= currentLevel) {
            this.currentParent = this.currentParent.getParent();
        }
    }

    private void setItemFather(int currentLevel) {
        if (this.currentParent == this.root) {
            return;
        }
        if (this.currentParent.getLevel() > currentLevel) {
            this.currentParent = this.currentParent.getParent();
            this.setItemFather(currentLevel);
            return;
        }
        if (this.currentParent.isItemNode()) {
            this.currentParent = this.currentParent.getParent();
            this.setItemFather(currentLevel);
            return;
        }
    }
}

