/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.manifest.v2.utils;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import org.eclipse.orion.server.cf.manifest.v2.InputLine;
import org.eclipse.orion.server.cf.manifest.v2.Token;
import org.eclipse.orion.server.cf.manifest.v2.Tokenizer;
import org.eclipse.orion.server.cf.manifest.v2.TokenizerException;
import org.eclipse.orion.server.cf.manifest.v2.utils.TokenPattern;

public class ManifestTokenizer
implements Tokenizer {
    private static TokenPattern indentationPattern = new TokenPattern(" {1,}", 0);
    private static TokenPattern[] tokenPatterns = new TokenPattern[]{new TokenPattern("- ", 2), new TokenPattern("(: +)|(:$)", 1), new TokenPattern("\\$\\{[^ \\t\\n\\x0b\\r\\f\\$\\{\\}]+\\} *", 3), new TokenPattern("(\"[^\\t\\n\\x0b\\r\\f\\$\\{\\}\"]*\" *)|([^ \\t\\n\\x0b\\r\\f\\$\\{\\}:][^ \\t\\n\\x0b\\r\\f\\$\\{\\}]*[^ \\t\\n\\x0b\\r\\f\\$\\{\\}:] *)|([^ \\t\\n\\x0b\\r\\f\\$\\{\\}] *)|(\\$[a-zA-Z0-9]+ *)", 4)};
    private List<InputLine> input;
    private InputLine currentLine;
    private int currentIndentation;

    public ManifestTokenizer(List<InputLine> input) {
        this.input = input;
        this.currentIndentation = 0;
    }

    @Override
    public boolean hasNext() {
        return !this.input.isEmpty() || this.currentLine != null;
    }

    @Override
    public Token getNextToken() throws TokenizerException {
        if (this.input.isEmpty() && this.currentLine == null) {
            throw new NoSuchElementException();
        }
        Token token = null;
        if (this.currentLine == null) {
            this.currentLine = this.input.remove(0);
            this.currentIndentation = 0;
            Matcher matcher = indentationPattern.getPattern().matcher(this.currentLine.getContent());
            if (matcher.find()) {
                String tokenValue = this.currentLine.getContent().substring(matcher.start(), matcher.end());
                this.currentIndentation = tokenValue.length();
                this.currentLine.setContent(matcher.replaceFirst(""));
                if (this.currentLine.getContent().isEmpty()) {
                    this.currentLine = null;
                }
                return this.getNextToken();
            }
        }
        TokenPattern[] tokenPatternArray = tokenPatterns;
        int n = tokenPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            TokenPattern tokenPattern = tokenPatternArray[n2];
            Matcher matcher = tokenPattern.getPattern().matcher(this.currentLine.getContent());
            if (matcher.find()) {
                String tokenValue = this.currentLine.getContent().substring(matcher.start(), matcher.end());
                token = new Token(tokenValue.trim(), tokenPattern.getType());
                token.setLineNumber(this.currentLine.getLineNumber());
                token.setIndentation(this.currentIndentation);
                this.currentLine.setContent(matcher.replaceFirst(""));
                if (2 != tokenPattern.getType()) break;
                this.currentIndentation += 2;
                break;
            }
            ++n2;
        }
        if (token == null) {
            throw new TokenizerException("Unexpected token around line {0}.", this.currentLine);
        }
        if (this.currentLine.getContent().isEmpty()) {
            this.currentLine = null;
        }
        return token;
    }
}

