/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.commands.GetAppCommand;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopAppCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Stop App";
    private App app;

    public StopAppCommand(Target target, App app) {
        super(target);
        this.app = app;
    }

    @Override
    public ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            String appUrl = this.app.getAppJSON().getString("url");
            URI appURI = targetURI.resolve(appUrl);
            PutMethod stopMethod = new PutMethod(appURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)stopMethod, this.target.getCloud());
            stopMethod.setQueryString("inline-relations-depth=1");
            JSONObject stopComand = new JSONObject();
            stopComand.put("console", true);
            stopComand.put("state", (Object)"STOPPED");
            StringRequestEntity requestEntity = new StringRequestEntity(stopComand.toString(), "application/json", "UTF-8");
            stopMethod.setRequestEntity((RequestEntity)requestEntity);
            GetAppCommand.expire(this.target, this.app.getName());
            return HttpUtil.executeMethod((HttpMethodBase)stopMethod);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

