/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.Cloud;
import org.eclipse.orion.server.cf.objects.Space;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSpaceCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName;
    private String spaceId;
    private Space space;

    public GetSpaceCommand(String userId, Cloud cloud, String spaceId) {
        super(cloud);
        this.spaceId = spaceId;
        this.commandName = "Get Space";
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.getCloud().getUrl());
            URI spacesURI = targetURI.resolve("/v2/spaces/" + this.spaceId);
            GetMethod getSpaceMethod = new GetMethod(spacesURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)getSpaceMethod, this.getCloud());
            getSpaceMethod.setQueryString("inline-relations-depth=1");
            ServerStatus status = HttpUtil.executeMethod((HttpMethodBase)getSpaceMethod);
            if (!status.isOK()) {
                return status;
            }
            this.space = new Space().setCFJSON(status.getJsonData());
            JSONObject result = this.space.toJSON();
            return new ServerStatus(Status.OK_STATUS, 200, result);
        }
        catch (ConnectTimeoutException e) {
            String msg = NLS.bind((String)"An error occurred when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 504, msg, (Throwable)e);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occurred when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }

    public Space getSpace() {
        return this.space;
    }
}

