/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.Org;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetOrgCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private boolean isGuid;
    private String defaultOrg;
    private String commandName;
    private String org;

    public SetOrgCommand(Target target, String orgName) {
        super(target);
        this.org = orgName;
        this.isGuid = false;
        this.defaultOrg = null;
        this.commandName = "Set Org";
    }

    public SetOrgCommand(Target target, String org, boolean isGuid) {
        super(target);
        this.org = org;
        this.isGuid = isGuid;
        this.defaultOrg = null;
        this.commandName = "Set Org";
    }

    public void setDefaultOrg(String defaultOrg) {
        this.defaultOrg = defaultOrg;
    }

    protected Org getOrganization(JSONArray orgs, String organization) throws JSONException {
        int i = 0;
        while (i < orgs.length()) {
            JSONObject orgJSON = orgs.getJSONObject(i);
            if (!this.isGuid && organization.equals(orgJSON.getJSONObject("entity").getString("name")) || this.isGuid && organization.equals(orgJSON.getJSONObject("metadata").getString("guid"))) {
                return new Org().setCFJSON(orgJSON);
            }
            ++i;
        }
        return null;
    }

    protected Org getArbitraryOrganization(JSONArray orgs) throws JSONException {
        JSONObject org = orgs.getJSONObject(0);
        return new Org().setCFJSON(org);
    }

    @Override
    public ServerStatus _doIt() {
        try {
            URI infoURI = URIUtil.toURI((URL)this.target.getUrl());
            infoURI = infoURI.resolve("/v2/organizations");
            GetMethod getMethod = new GetMethod(infoURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)getMethod, this.target.getCloud());
            ServerStatus getStatus = HttpUtil.executeMethod((HttpMethodBase)getMethod);
            if (!getStatus.isOK()) {
                return getStatus;
            }
            JSONObject result = getStatus.getJsonData();
            JSONArray orgs = result.getJSONArray("resources");
            if (orgs.length() == 0) {
                return new ServerStatus(4, 404, "Organization not found", null);
            }
            if (this.org == null || "".equals(this.org)) {
                Org organization = null;
                if (this.defaultOrg != null) {
                    organization = this.getOrganization(orgs, this.defaultOrg);
                    if (organization == null) {
                        organization = this.getArbitraryOrganization(orgs);
                    }
                } else {
                    organization = this.getArbitraryOrganization(orgs);
                }
                this.target.setOrg(organization);
            } else {
                Org organization = this.getOrganization(orgs, this.org);
                this.target.setOrg(organization);
            }
            if (this.target.getOrg() == null) {
                return new ServerStatus(4, 404, "Organization not found", null);
            }
            return new ServerStatus(Status.OK_STATUS, 200, this.target.getOrg().toJSON());
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

