/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.loggregator;

import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.orion.server.cf.loggregator.LoggregatorMessage;
import org.json.JSONArray;

public class LoggregatorListener {
    private SortedSet<LoggregatorMessage.Message> messages;
    private long lastTimestamp = -1L;

    public void add(LoggregatorMessage.Message msg) {
        if (this.messages == null) {
            Comparator<LoggregatorMessage.Message> comparator = new Comparator<LoggregatorMessage.Message>(){

                @Override
                public int compare(LoggregatorMessage.Message o1, LoggregatorMessage.Message o2) {
                    if (o1.getTimestamp() < o2.getTimestamp()) {
                        return -1;
                    }
                    if (o1.getTimestamp() > o2.getTimestamp()) {
                        return 1;
                    }
                    return 0;
                }
            };
            this.messages = new TreeSet<LoggregatorMessage.Message>(comparator);
        }
        this.messages.add(msg);
    }

    public long getLastTimestamp() {
        return this.lastTimestamp;
    }

    public JSONArray getMessagesJSON() {
        JSONArray messagesJSON = new JSONArray();
        if (this.messages != null) {
            for (LoggregatorMessage.Message loggregatorMessage : this.messages) {
                String message = loggregatorMessage.getMessage().toStringUtf8();
                messagesJSON.put((Object)message);
                this.lastTimestamp = loggregatorMessage.getTimestamp();
            }
        }
        return messagesJSON;
    }

    public String getString() {
        StringBuffer buff = new StringBuffer();
        if (this.messages != null) {
            Iterator iterator = this.messages.iterator();
            while (iterator.hasNext()) {
                String message = ((LoggregatorMessage.Message)iterator.next()).getMessage().toStringUtf8();
                buff.append(message).append("\n");
            }
        }
        return buff.toString();
    }
}

