/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.jsch;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import org.eclipse.orion.server.jsch.HostFingerprintException;
import org.eclipse.orion.server.jsch.JSchUtil;
import org.eclipse.orion.server.jsch.LazyKnownHosts;

public class SessionHandler {
    private Session session;
    private JSch jSch = new JSch();

    public SessionHandler(String user, String host, int port, String knownHosts, byte[] privateKey, byte[] publicKey, byte[] passphrase) throws JSchException {
        JSchUtil.knownHosts(this.jSch, knownHosts);
        JSchUtil.identity(this.jSch, privateKey, publicKey, passphrase);
        this.session = this.jSch.getSession(user, host, port);
        this.session.setConfig("MaxAuthTries", "1");
    }

    public void setPassword(String password) {
        this.session.setPassword(password);
    }

    public void setUserInfo(UserInfo userInfo) {
        this.session.setUserInfo(userInfo);
    }

    public Session getSession() {
        return this.session;
    }

    public JSch getjSch() {
        return this.jSch;
    }

    public void connect(int tms) throws JSchException {
        try {
            if (!this.session.isConnected()) {
                this.session.connect(tms);
            }
        }
        catch (JSchException e) {
            LazyKnownHosts hostsRepo;
            if (this.jSch.getHostKeyRepository() instanceof LazyKnownHosts && (hostsRepo = (LazyKnownHosts)this.jSch.getHostKeyRepository()).getLastStatus() != 0) {
                throw new HostFingerprintException(hostsRepo.getLastUnknownkedHost(), hostsRepo.getLastUnknownKey());
            }
            throw e;
        }
    }
}

