/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.file;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.file.DirectoryHandlerV1;
import org.eclipse.orion.internal.server.servlets.file.FileHandlerV1;
import org.eclipse.orion.internal.server.servlets.file.GenericDirectoryHandler;
import org.eclipse.orion.internal.server.servlets.file.GenericFileHandler;
import org.eclipse.orion.server.core.EncodingUtils;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Version;

public class ServletFileStoreHandler
extends ServletResourceHandler<IFileStore> {
    public static VersionRange VERSION1 = new VersionRange("[1,2)");
    private static int[] ATTRIBUTE_BITS = new int[]{8, 4, 16, 0x200000, 2, 32};
    private static String[] ATTRIBUTE_KEYS = new String[]{"Archive", "Executable", "Hidden", "Immutable", "ReadOnly", "SymLink"};
    private final ServletResourceHandler<IFileStore> directorySerializerV1;
    private final ServletResourceHandler<IFileStore> fileSerializerV1;
    private final ServletResourceHandler<IFileStore> genericDirectorySerializer;
    private final ServletResourceHandler<IFileStore> genericFileSerializer;
    final ServletResourceHandler<IStatus> statusHandler;

    public static IFileInfo fromJSON(JSONObject object) {
        FileInfo info = (FileInfo)EFS.createFileInfo();
        ServletFileStoreHandler.copyJSONToFileInfo(object, info);
        return info;
    }

    public static void copyJSONToFileInfo(JSONObject source, FileInfo destination) {
        destination.setName(source.optString("Name", destination.getName()));
        destination.setLastModified(source.optLong("LastModified", destination.getLastModified()));
        destination.setDirectory(source.optBoolean("Directory", destination.isDirectory()));
        JSONObject attributes = source.optJSONObject("Attributes");
        if (attributes != null) {
            int i = 0;
            while (i < ATTRIBUTE_KEYS.length) {
                if (!attributes.isNull(ATTRIBUTE_KEYS[i])) {
                    destination.setAttribute(ATTRIBUTE_BITS[i], attributes.optBoolean(ATTRIBUTE_KEYS[i]));
                }
                ++i;
            }
        }
    }

    public static IFileInfo fromJSON(HttpServletRequest request) throws IOException, JSONException {
        return ServletFileStoreHandler.fromJSON(OrionServlet.readJSONRequest(request));
    }

    public static JSONObject toJSON(IFileStore store, IFileInfo info, URI location) {
        JSONObject result = new JSONObject();
        try {
            result.put("Name", (Object)info.getName());
            result.put("LocalTimeStamp", info.getLastModified());
            result.put("Directory", info.isDirectory());
            result.put("Length", info.getLength());
            if (location != null) {
                if (info.isDirectory() && !location.getPath().endsWith("/")) {
                    location = URIUtil.append((URI)location, (String)"");
                }
                result.put("Location", (Object)location);
                if (info.isDirectory()) {
                    try {
                        result.put("ChildrenLocation", (Object)new URI(location.getScheme(), location.getAuthority(), location.getPath(), "depth=1", location.getFragment()));
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            result.put("Attributes", (Object)ServletFileStoreHandler.getAttributes(store, info));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private static JSONObject getAttributes(IFileStore store, IFileInfo info) throws JSONException {
        int supported = store.getFileSystem().attributes();
        JSONObject attributes = new JSONObject();
        int i = 0;
        while (i < ATTRIBUTE_KEYS.length) {
            if ((supported & ATTRIBUTE_BITS[i]) != 0) {
                attributes.put(ATTRIBUTE_KEYS[i], info.getAttribute(ATTRIBUTE_BITS[i]));
            }
            ++i;
        }
        return attributes;
    }

    public ServletFileStoreHandler(ServletResourceHandler<IStatus> statusHandler, ServletContext context) {
        this.statusHandler = statusHandler;
        this.fileSerializerV1 = new FileHandlerV1(statusHandler, context);
        this.genericFileSerializer = new GenericFileHandler(context);
        this.directorySerializerV1 = new DirectoryHandlerV1(statusHandler);
        this.genericDirectorySerializer = new GenericDirectoryHandler();
    }

    private boolean handleDirectory(HttpServletRequest request, HttpServletResponse response, IFileStore file) throws ServletException {
        String versionString = request.getHeader("Orion-Version");
        Version version = versionString == null ? null : new Version(versionString);
        ServletResourceHandler<IFileStore> handler = version != null && VERSION1.isIncluded(version) ? this.directorySerializerV1 : this.genericDirectorySerializer;
        return handler.handleRequest(request, response, file);
    }

    private boolean handleFile(HttpServletRequest request, HttpServletResponse response, IFileStore file) throws ServletException {
        String versionString = request.getHeader("Orion-Version");
        Version version = versionString == null ? null : new Version(versionString);
        ServletResourceHandler<IFileStore> handler = version != null && VERSION1.isIncluded(version) ? this.fileSerializerV1 : this.genericFileSerializer;
        return handler.handleRequest(request, response, file);
    }

    @Override
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, IFileStore file) throws ServletException {
        IFileInfo fileInfo;
        try {
            fileInfo = file.fetchInfo(0, null);
        }
        catch (CoreException e) {
            if (this.handleAuthFailure(request, response, (Exception)((Object)e))) {
                return true;
            }
            fileInfo = new FileInfo(file.getName());
            ((FileInfo)fileInfo).setExists(false);
        }
        if (!request.getMethod().equals("PUT") && !fileInfo.exists()) {
            return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 404, NLS.bind((String)"File not found: {0}", (Object)EncodingUtils.encodeForHTML((String)request.getPathInfo())), null));
        }
        if (fileInfo.isDirectory()) {
            return this.handleDirectory(request, response, file);
        }
        return this.handleFile(request, response, file);
    }
}

