/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.eclipse.orion.server.cf.ds.DeploymentService;
import org.eclipse.orion.server.cf.ds.DeploymentServiceTracker;
import org.eclipse.orion.server.cf.ds.IDeploymentService;
import org.eclipse.orion.server.cf.ext.CFDeploymentExtService;
import org.eclipse.orion.server.cf.ext.CFDeploymentExtServiceTracker;
import org.eclipse.orion.server.cf.ext.ICFDeploymentExtService;
import org.eclipse.orion.server.cf.utils.TargetRegistry;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class CFActivator
implements BundleActivator {
    public static final String PI_CF = "org.eclipse.orion.server.cf";
    private static CFActivator instance;
    private BundleContext bundleContext;
    private TargetRegistry targetRegistry = new TargetRegistry();
    private ServiceTracker<DeploymentService, IDeploymentService> deploymentServiceTracker;
    private ServiceTracker<CFDeploymentExtService, ICFDeploymentExtService> cfDeploymentExtServiceTracker;

    public void start(BundleContext context) throws Exception {
        instance = this;
        this.bundleContext = context;
        DeploymentServiceTracker customer = new DeploymentServiceTracker(context);
        this.deploymentServiceTracker = new ServiceTracker(context, DeploymentService.class.getName(), (ServiceTrackerCustomizer)customer);
        this.deploymentServiceTracker.open();
        CFDeploymentExtServiceTracker extCustomer = new CFDeploymentExtServiceTracker(context);
        this.cfDeploymentExtServiceTracker = new ServiceTracker(context, CFDeploymentExtService.class.getName(), (ServiceTrackerCustomizer)extCustomer);
        this.cfDeploymentExtServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.bundleContext = null;
        instance = null;
        this.deploymentServiceTracker.close();
        this.cfDeploymentExtServiceTracker.close();
    }

    public static CFActivator getDefault() {
        return instance;
    }

    public BundleContext getContext() {
        return this.bundleContext;
    }

    public TargetRegistry getTargetRegistry() {
        return this.targetRegistry;
    }

    public IDeploymentService getDeploymentService() {
        return (IDeploymentService)this.deploymentServiceTracker.getService();
    }

    public ICFDeploymentExtService getCFDeploymentExtDeploymentService() {
        return (ICFDeploymentExtService)this.cfDeploymentExtServiceTracker.getService();
    }

    public synchronized HttpClient getHttpClient() {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams connectionManagerParams = connectionManager.getParams();
        connectionManagerParams.setConnectionTimeout(30000);
        connectionManager.setParams(connectionManagerParams);
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setConnectionManagerTimeout(300000L);
        return new HttpClient(clientParams, (HttpConnectionManager)connectionManager);
    }
}

