/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetServiceByNameCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Get service by name";
    private String serviceName;

    public GetServiceByNameCommand(Target target, String serviceName) {
        super(target);
        this.serviceName = serviceName;
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            URI servicesURI = targetURI.resolve("/v2/spaces/" + this.target.getSpace().getGuid() + "/services");
            GetMethod getServicesMethod = new GetMethod(servicesURI.toString());
            NameValuePair[] params = new NameValuePair[]{new NameValuePair("q", "label:" + this.serviceName), new NameValuePair("inline-relations-depth", "1")};
            getServicesMethod.setQueryString(params);
            HttpUtil.configureHttpMethod((HttpMethod)getServicesMethod, this.target.getCloud());
            return HttpUtil.executeMethod((HttpMethodBase)getServicesMethod);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

