/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.Cloud;
import org.eclipse.orion.server.cf.objects.Route;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRouteByGuidCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Get route";
    private String routeGuid;
    private Route route;

    public GetRouteByGuidCommand(Cloud cloud, String routeGuid) {
        super(cloud);
        this.routeGuid = routeGuid;
    }

    @Override
    public ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.getCloud().getUrl());
            URI appsURI = targetURI.resolve("/v2/routes/" + this.routeGuid);
            GetMethod getRoutesMethod = new GetMethod(appsURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)getRoutesMethod, this.getCloud());
            ServerStatus getStatus = HttpUtil.executeMethod((HttpMethodBase)getRoutesMethod);
            if (!getStatus.isOK()) {
                return getStatus;
            }
            JSONObject routeJSON = getStatus.getJsonData();
            this.route = new Route().setCFJSON(routeJSON);
            return new ServerStatus(Status.OK_STATUS, 200, this.route.toJSON());
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }

    public Route getRoute() {
        return this.route;
    }
}

