/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.cf.commands.ICFCommand;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutCommand
implements ICFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private static final String INVALID_TOKEN = "InvalidToken";
    private String commandName = "Log out";
    private Target target;
    private boolean invalidate;

    public LogoutCommand(Target target, boolean invalidate) {
        this.target = target;
        this.invalidate = invalidate;
    }

    @Override
    public IStatus doIt() {
        try {
            if (this.invalidate) {
                JSONObject invalidToken = new JSONObject();
                invalidToken.put("access_token", (Object)INVALID_TOKEN);
                this.target.getCloud().setAccessToken(invalidToken);
            } else {
                this.target.getCloud().setAccessToken(null);
            }
            return new ServerStatus(Status.OK_STATUS, 200);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occurred when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

