/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.loggregator.LoggregatorListener;
import org.eclipse.orion.server.cf.loggregator.LoggregatorMessage;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.cf.utils.MultipartMessageReader;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetLogCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Get App Log";
    private String appId;
    private String loggingEndpoint;
    private LoggregatorListener listener;

    public GetLogCommand(Target target, String loggingEndpoint, String appId, LoggregatorListener listener) {
        super(target);
        this.loggingEndpoint = loggingEndpoint;
        this.appId = appId;
        this.listener = listener;
    }

    @Override
    public ServerStatus _doIt() {
        try {
            ServerStatus getLogStatus;
            if (this.loggingEndpoint.startsWith("wss://")) {
                this.loggingEndpoint = this.loggingEndpoint.replace("wss://", "https://");
            } else if (this.loggingEndpoint.startsWith("ws://")) {
                this.loggingEndpoint = this.loggingEndpoint.replace("ws://", "http://");
            }
            URI infoURI = URIUtil.toURI((URL)new URL(this.loggingEndpoint)).resolve("/recent?app=" + this.appId);
            GetMethod getLogMethod = new GetMethod(infoURI.toString());
            getLogMethod.addRequestHeader(new Header("Content-Type", "multipart/form-data"));
            if (this.target.getCloud().getAccessToken() != null) {
                getLogMethod.addRequestHeader(new Header("Authorization", "bearer " + this.target.getCloud().getAccessToken().getString("access_token")));
            }
            if (!(getLogStatus = HttpUtil.executeMethod((HttpMethodBase)getLogMethod)).isOK()) {
                return getLogStatus;
            }
            Header contentType = getLogMethod.getResponseHeader("Content-Type");
            String contentTypeValue = contentType.getValue();
            String[] values = contentTypeValue.split(";");
            String boundary = null;
            int i = 0;
            while (i < values.length) {
                if (values[i].trim().startsWith("boundary")) {
                    boundary = values[i].split("=")[1];
                    break;
                }
                ++i;
            }
            if (boundary == null) {
                String msg = NLS.bind((String)"An error occured when performing operation {0}. Boundary in response header not found.", (Object)this.commandName);
                this.logger.error(msg);
                return new ServerStatus(4, 500, msg, null);
            }
            InputStream responseStream = getLogMethod.getResponseBodyAsStream();
            try {
                byte[] messageBody = this.getMessageBody(responseStream);
                MultipartMessageReader multipartReader = new MultipartMessageReader(boundary, messageBody);
                while (multipartReader.readNextPart()) {
                    try {
                        LoggregatorMessage.Message message = LoggregatorMessage.Message.parseFrom(multipartReader.getPart());
                        this.listener.add(message);
                    }
                    catch (Exception ex) {
                        this.logger.error("Problem while reading logs", (Throwable)ex);
                    }
                }
            }
            finally {
                responseStream.close();
            }
            return new ServerStatus(Status.OK_STATUS, 200);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }

    private byte[] getMessageBody(InputStream responseStream) throws IOException {
        int readBytes;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((readBytes = responseStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, readBytes);
        }
        byte[] messageBody = buffer.toByteArray();
        return messageBody;
    }
}

