/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.eclipse.orion.server.git.objects.Commit;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="StashCommit")
public class Stash
extends Commit {
    public static final String RESOURCE = "stash";
    public static final String TYPE = "StashCommit";
    protected static final ResourceShape EXTENDED_RESOURCE_SHAPE = new ResourceShape();

    public Stash(URI cloneLocation, Repository db, RevCommit revCommit, String pattern) {
        super(cloneLocation, db, revCommit, pattern);
        EXTENDED_RESOURCE_SHAPE.setProperties(DEFAULT_RESOURCE_SHAPE.getProperties());
        EXTENDED_RESOURCE_SHAPE.addProperty(new Property("ApplyLocation"));
        EXTENDED_RESOURCE_SHAPE.addProperty(new Property("DropLocation"));
    }

    protected URI createStashLocation() throws URISyntaxException {
        IPath stashPath = new Path("/gitapi").append(RESOURCE);
        stashPath = stashPath.append(this.getName());
        IPath clonePath = new Path(this.cloneLocation.getPath()).removeFirstSegments(2);
        stashPath = stashPath.append(clonePath);
        return new URI(this.cloneLocation.getScheme(), this.cloneLocation.getAuthority(), stashPath.toString(), null, null);
    }

    @PropertyDescription(name="ApplyLocation")
    public URI getApplyLocation() throws URISyntaxException {
        return this.createStashLocation();
    }

    @PropertyDescription(name="DropLocation")
    public URI getDropLocation() throws URISyntaxException {
        return this.createStashLocation();
    }

    @Override
    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, EXTENDED_RESOURCE_SHAPE);
    }
}

