/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.commands.GetDomainsCommand;
import org.eclipse.orion.server.cf.objects.Route;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRoutesCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Get Routes";
    private String domainName;
    private String hostName;
    private boolean orphaned;
    private List<Route> routes;

    public GetRoutesCommand(Target target, boolean orphaned) {
        super(target);
        this.orphaned = orphaned;
    }

    public GetRoutesCommand(Target target, String domainName, String hostName) {
        super(target);
        this.domainName = domainName;
        this.hostName = hostName;
    }

    public List<Route> getRoutes() {
        this.assertWasRun();
        return this.routes;
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            JSONObject routesJSON;
            ServerStatus getRouteStatus;
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            if (this.domainName != null && this.hostName != null) {
                GetDomainsCommand getDomainsCommand = new GetDomainsCommand(this.target, this.domainName);
                ServerStatus getDomainsStatus = (ServerStatus)getDomainsCommand.doIt();
                if (!getDomainsStatus.isOK()) {
                    return getDomainsStatus;
                }
                String domainId = getDomainsCommand.getDomains().get(0).getGuid();
                URI routesURI = targetURI.resolve("/v2/routes");
                GetMethod getRouteMethod = new GetMethod(routesURI.toString());
                HttpUtil.configureHttpMethod((HttpMethod)getRouteMethod, this.target.getCloud());
                getRouteMethod.setQueryString("inline-relations-depth=1&q=" + URLEncoder.encode("host:" + this.hostName + ";" + "domain_guid" + ":" + domainId, "UTF8"));
                getRouteStatus = HttpUtil.executeMethod((HttpMethodBase)getRouteMethod);
                if (!getRouteStatus.isOK()) {
                    return getRouteStatus;
                }
            } else {
                String routesURL = this.target.getSpace().getCFJSON().getJSONObject("entity").getString("routes_url");
                URI routesURI = targetURI.resolve(routesURL);
                GetMethod getRoutesMethod = new GetMethod(routesURI.toString());
                HttpUtil.configureHttpMethod((HttpMethod)getRoutesMethod, this.target.getCloud());
                getRoutesMethod.setQueryString("inline-relations-depth=1");
                getRouteStatus = HttpUtil.executeMethod((HttpMethodBase)getRoutesMethod);
                if (!getRouteStatus.isOK()) {
                    return getRouteStatus;
                }
            }
            if ((routesJSON = getRouteStatus.getJsonData()).getInt("total_results") < 1) {
                return new ServerStatus(0, 200, null, null);
            }
            JSONObject result = new JSONObject();
            this.routes = new ArrayList<Route>();
            JSONArray resources = routesJSON.getJSONArray("resources");
            int k = 0;
            while (k < resources.length()) {
                JSONObject routeJSON = resources.getJSONObject(k);
                Route route = new Route();
                route.setCFJSON(routeJSON);
                if (!this.orphaned || route.getCFJSON().getJSONObject("entity").getJSONArray("apps").length() == 0) {
                    this.routes.add(route);
                    result.append("Routes", (Object)route.toJSON());
                }
                ++k;
            }
            return new ServerStatus(Status.OK_STATUS, 200, result);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

