/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.handlers.v1;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.cf.commands.ComputeTargetCommand;
import org.eclipse.orion.server.cf.commands.GetAppCommand;
import org.eclipse.orion.server.cf.commands.GetInfoCommand;
import org.eclipse.orion.server.cf.commands.GetLogCommand;
import org.eclipse.orion.server.cf.jobs.CFJob;
import org.eclipse.orion.server.cf.loggregator.LoggregatorListener;
import org.eclipse.orion.server.cf.loggregator.LoggregatorRegistry;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Log;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.servlets.AbstractRESTHandler;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggregatorHandlerV1
extends AbstractRESTHandler<Log> {
    final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private LoggregatorRegistry loggregatorRegistry = new LoggregatorRegistry();

    public LoggregatorHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    @Override
    protected Log buildResource(HttpServletRequest request, String pathString) throws CoreException {
        return null;
    }

    @Override
    protected CFJob handleGet(Log log, HttpServletRequest request, HttpServletResponse response, String pathString) {
        final JSONObject targetJSON = this.extractJSONData(IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Target"));
        final String timestampStr = IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Timestamp");
        Path path = new Path(pathString);
        final String appName = path.segment(0);
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    LoggregatorHandlerV1.this.logger.debug(NLS.bind((String)"LoggregatorHandlerV1 starts collecting logs for: {0}", (Object)appName));
                    ComputeTargetCommand computeTargetCommand = new ComputeTargetCommand(this.userId, targetJSON);
                    IStatus result = computeTargetCommand.doIt();
                    if (!result.isOK()) {
                        return result;
                    }
                    Target target = computeTargetCommand.getTarget();
                    GetAppCommand getAppCommand = new GetAppCommand(target, appName);
                    IStatus getAppStatus = getAppCommand.doIt();
                    if (!getAppStatus.isOK()) {
                        return getAppStatus;
                    }
                    App app = getAppCommand.getApp();
                    GetInfoCommand getInfoCommand = new GetInfoCommand(target.getCloud());
                    ServerStatus getInfoStatus = (ServerStatus)getInfoCommand.doIt();
                    if (!getInfoStatus.isOK()) {
                        return getInfoStatus;
                    }
                    LoggregatorHandlerV1.this.logger.debug(NLS.bind((String)"Cloud info: {0}", (Object)getInfoStatus.getJsonData().toString()));
                    String loggingEndpoint = getInfoStatus.getJsonData().getString("logging_endpoint");
                    JSONObject messages = new JSONObject();
                    LoggregatorListener listener = LoggregatorHandlerV1.this.loggregatorRegistry.getListener(app.getGuid());
                    GetLogCommand getLogCommand = new GetLogCommand(target, loggingEndpoint, app.getAppJSON().getString("guid"), listener);
                    getLogCommand.doIt();
                    long timestamp = timestampStr != null ? Long.parseLong(timestampStr) : -1L;
                    JSONArray listenerMessages = listener.getMessagesJSON();
                    messages.put("Messages", (Object)(timestamp < listener.getLastTimestamp() ? listenerMessages : new JSONArray()));
                    messages.put("Timestamp", (Object)new Long(listener.getLastTimestamp()).toString());
                    return new ServerStatus(0, 200, null, messages, null);
                }
                catch (Exception e) {
                    String msg = "Unable to retrieve the application logs from the Cloud Foundry runtime.  Please try again later.";
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    LoggregatorHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
                catch (NoClassDefFoundError e) {
                    String msg = "Unable to retrieve the application logs from the Cloud Foundry runtime.  Please try again later.";
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    if (e.getMessage().equals("org/eclipse/jetty/websocket/client/WebSocketClient")) {
                        msg = "The application logs cannot be retrieved for this version of Cloud Foundry";
                        status = new ServerStatus(4, 500, msg, null);
                    }
                    LoggregatorHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }
}

