/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.gerritfs;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.io.NullOutputStream;

public class DiffCommand
extends GitCommand<List<DiffEntry>> {
    private AbstractTreeIterator oldTree;
    private AbstractTreeIterator newTree;
    private boolean cached;
    private TreeFilter pathFilter = TreeFilter.ALL;
    private boolean showNameAndStatusOnly;
    private OutputStream out;
    private int contextLines = -1;
    private String sourcePrefix;
    private String destinationPrefix;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    boolean ignoreWS;

    public DiffCommand(Repository repo) {
        super(repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DiffEntry> call() throws GitAPIException {
        DiffFormatter diffFmt = this.out != null && !this.showNameAndStatusOnly ? new DiffFormatter((OutputStream)new BufferedOutputStream(this.out)) : new DiffFormatter((OutputStream)NullOutputStream.INSTANCE);
        if (this.ignoreWS) {
            diffFmt.setDiffComparator(RawTextComparator.WS_IGNORE_ALL);
        }
        diffFmt.setRepository(this.repo);
        diffFmt.setProgressMonitor(this.monitor);
        try {
            List list;
            if (this.cached) {
                if (this.oldTree == null) {
                    ObjectId head = this.repo.resolve("HEAD^{tree}");
                    if (head == null) {
                        throw new NoHeadException(JGitText.get().cannotReadTree);
                    }
                    CanonicalTreeParser p = new CanonicalTreeParser();
                    ObjectReader reader = this.repo.newObjectReader();
                    try {
                        p.reset(reader, (AnyObjectId)head);
                    }
                    finally {
                        reader.release();
                    }
                    this.oldTree = p;
                }
                this.newTree = new DirCacheIterator(this.repo.readDirCache());
            } else {
                if (this.oldTree == null) {
                    this.oldTree = new DirCacheIterator(this.repo.readDirCache());
                }
                if (this.newTree == null) {
                    this.newTree = new FileTreeIterator(this.repo);
                }
            }
            diffFmt.setPathFilter(this.pathFilter);
            List result = diffFmt.scan(this.oldTree, this.newTree);
            if (this.showNameAndStatusOnly) {
                list = result;
                return list;
            }
            if (this.contextLines >= 0) {
                diffFmt.setContext(this.contextLines);
            }
            if (this.destinationPrefix != null) {
                diffFmt.setNewPrefix(this.destinationPrefix);
            }
            if (this.sourcePrefix != null) {
                diffFmt.setOldPrefix(this.sourcePrefix);
            }
            diffFmt.format(result);
            diffFmt.flush();
            list = result;
            return list;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), (Throwable)e);
        }
        finally {
            diffFmt.release();
        }
    }

    public DiffCommand setCached(boolean cached) {
        this.cached = cached;
        return this;
    }

    public DiffCommand setPathFilter(TreeFilter pathFilter) {
        this.pathFilter = pathFilter;
        return this;
    }

    public DiffCommand setOldTree(AbstractTreeIterator oldTree) {
        this.oldTree = oldTree;
        return this;
    }

    public DiffCommand setNewTree(AbstractTreeIterator newTree) {
        this.newTree = newTree;
        return this;
    }

    public DiffCommand setShowNameAndStatusOnly(boolean showNameAndStatusOnly) {
        this.showNameAndStatusOnly = showNameAndStatusOnly;
        return this;
    }

    public DiffCommand setOutputStream(OutputStream out) {
        this.out = out;
        return this;
    }

    public DiffCommand setContextLines(int contextLines) {
        this.contextLines = contextLines;
        return this;
    }

    public DiffCommand setSourcePrefix(String sourcePrefix) {
        this.sourcePrefix = sourcePrefix;
        return this;
    }

    public DiffCommand setDestinationPrefix(String destinationPrefix) {
        this.destinationPrefix = destinationPrefix;
        return this;
    }

    public DiffCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public DiffCommand setIgnoreWhiteSpace(boolean ignoreWS) {
        this.ignoreWS = ignoreWS;
        return this;
    }
}

