/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.commands.GetAppCommand;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartAppCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Start App";
    private App app;
    private int timeout;

    public StartAppCommand(Target target, App app, int timeout) {
        super(target);
        this.app = app;
        this.timeout = timeout;
    }

    public StartAppCommand(Target target, App app) {
        super(target);
        this.app = app;
        this.timeout = -1;
    }

    @Override
    public ServerStatus _doIt() {
        GetAppCommand.expire(this.target, this.app.getName());
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            String appUrl = this.app.getAppJSON().getString("url");
            URI appURI = targetURI.resolve(appUrl);
            PutMethod startMethod = new PutMethod(appURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)startMethod, this.target.getCloud());
            startMethod.setQueryString("inline-relations-depth=1");
            JSONObject startCommand = new JSONObject();
            startCommand.put("console", true);
            startCommand.put("state", (Object)"STARTED");
            StringRequestEntity requestEntity = new StringRequestEntity(startCommand.toString(), "application/json", "UTF-8");
            startMethod.setRequestEntity((RequestEntity)requestEntity);
            ServerStatus startStatus = HttpUtil.executeMethod((HttpMethodBase)startMethod);
            if (!startStatus.isOK()) {
                return startStatus;
            }
            GetAppCommand.expire(this.target, this.app.getName());
            if (this.timeout < 0) {
                ManifestParseTree manifest = this.app.getManifest();
                ManifestParseTree timeoutNode = manifest.get("applications").get(0).getOpt("timeout");
                this.timeout = timeoutNode != null ? Integer.parseInt(timeoutNode.getValue()) : 60;
            }
            this.timeout = Math.min(this.timeout, 180);
            int attemptsLeft = this.timeout / 2;
            String msg = NLS.bind((String)"An error occurred during application startup", (Object)this.commandName);
            ServerStatus checkAppStatus = new ServerStatus(2, 400, msg, null);
            while (attemptsLeft > 0) {
                Thread.sleep(2000L);
                String appInstancesUrl = String.valueOf(appUrl) + "/instances";
                URI appInstancesURI = targetURI.resolve(appInstancesUrl);
                GetMethod getInstancesMethod = new GetMethod(appInstancesURI.toString());
                HttpUtil.configureHttpMethod((HttpMethod)getInstancesMethod, this.target.getCloud());
                checkAppStatus = HttpUtil.executeMethod((HttpMethodBase)getInstancesMethod);
                if (!checkAppStatus.isOK()) {
                    --attemptsLeft;
                    continue;
                }
                JSONObject appInstancesJSON = checkAppStatus.getJsonData();
                int instancesNo = appInstancesJSON.length();
                int runningInstanceNo = 0;
                int flappingInstanceNo = 0;
                Iterator instanceIt = appInstancesJSON.keys();
                while (instanceIt.hasNext()) {
                    JSONObject instanceJSON = appInstancesJSON.getJSONObject((String)instanceIt.next());
                    if ("RUNNING".equals(instanceJSON.optString("state"))) {
                        ++runningInstanceNo;
                        continue;
                    }
                    if (!"FLAPPING".equals(instanceJSON.optString("state"))) continue;
                    ++flappingInstanceNo;
                }
                if (runningInstanceNo == instancesNo) break;
                if (flappingInstanceNo > 0) {
                    msg = NLS.bind((String)"An error occurred during application startup", (Object)this.commandName);
                    checkAppStatus = new ServerStatus(2, 400, msg, checkAppStatus.getJsonData(), null);
                    break;
                }
                if (--attemptsLeft != 0) continue;
                msg = NLS.bind((String)"An error occurred during application startup", (Object)this.commandName);
                checkAppStatus = new ServerStatus(2, 400, msg, checkAppStatus.getJsonData(), null);
            }
            return checkAppStatus;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

